/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ansj.app.crf.SplitWord;
import org.ansj.dic.LearnTool;
import org.ansj.domain.Nature;
import org.ansj.domain.NewWord;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.CrfLibrary;
import org.ansj.recognition.arrimpl.AsianPersonRecognition;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;
import org.ansj.recognition.arrimpl.NewWordRecognition;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.recognition.arrimpl.UserDefineRecognition;
import org.ansj.recognition.impl.NatureRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.NameFix;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.MapCount;
import org.nlpcn.commons.lang.util.WordAlert;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class NlpAnalysis
extends Analysis {
    private static final Log LOG = LogFactory.getLog(NlpAnalysis.class);
    private LearnTool learn = null;
    private static final String TAB = "\t";
    private static final int CRF_WEIGHT = 6;
    private SplitWord splitWord = CrfLibrary.get();
    private static final Set<Character> filter = new HashSet<Character>();

    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                if (NlpAnalysis.this.learn == null) {
                    NlpAnalysis.this.learn = new LearnTool();
                }
                graph.walkPath();
                NlpAnalysis.this.learn.learn(graph, NlpAnalysis.this.splitWord);
                if (graph.hasPerson && NlpAnalysis.this.isNameRecognition.booleanValue()) {
                    new AsianPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                    NameFix.nameAmbiguity(graph.terms, new Forest[0]);
                    new ForeignPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                }
                if (NlpAnalysis.this.splitWord != null) {
                    String word;
                    MapCount mc = new MapCount();
                    List<String> words = NlpAnalysis.this.splitWord.cut(graph.chars);
                    Term tempTerm = null;
                    int tempOff = 0;
                    if (words.size() > 0 && !NlpAnalysis.isRuleWord(word = words.get(0))) {
                        mc.add((Object)("\u59cb##\u59cb\t" + word), 6);
                    }
                    for (String word2 : words) {
                        TermNatures termNatures = new NatureRecognition(NlpAnalysis.this.forests).getTermNatures(word2);
                        Term term = null;
                        if (termNatures != TermNatures.NULL) {
                            term = new Term(word2, tempOff, termNatures);
                        } else {
                            term = new Term(word2, tempOff, TermNatures.NW);
                            term.setNewWord(true);
                        }
                        tempOff += word2.length();
                        if (NlpAnalysis.isRuleWord(word2)) {
                            tempTerm = null;
                            continue;
                        }
                        if (term.isNewWord()) {
                            termNatures = NatureRecognition.guessNature(word2);
                            term.updateTermNaturesAndNature(termNatures);
                        }
                        TermUtil.insertTerm(graph.terms, term, TermUtil.InsertTermType.SCORE_ADD_SORT);
                        if (tempTerm != null && !tempTerm.isNewWord() && !term.isNewWord()) {
                            mc.add((Object)(tempTerm.getName() + NlpAnalysis.TAB + word2), 6);
                        }
                        tempTerm = term;
                        if (!term.isNewWord()) continue;
                        NlpAnalysis.this.learn.addTerm(new NewWord(word2, Nature.NW));
                    }
                    if (tempTerm != null && !tempTerm.isNewWord()) {
                        mc.add((Object)(tempTerm.getName() + NlpAnalysis.TAB + "\u672b##\u672b"), 6);
                    }
                    graph.walkPath(mc.get());
                } else {
                    LOG.warn("not find any crf model, make sure your config right? ");
                }
                if (graph.hasNum && NlpAnalysis.this.isNumRecognition.booleanValue()) {
                    new NumRecognition().recognition(graph.terms);
                }
                List<Term> result = this.getResult();
                new UserDefineRecognition(TermUtil.InsertTermType.SCORE_ADD_SORT, NlpAnalysis.this.forests).recognition(graph.terms);
                graph.rmLittlePath();
                graph.walkPathByScore();
                new NewWordRecognition(NlpAnalysis.this.learn).recognition(graph.terms);
                graph.walkPathByScore();
                result = this.getResult();
                for (Term term : result) {
                    NlpAnalysis.this.learn.active(term.getName());
                }
                NlpAnalysis.this.setRealName(graph, result);
                return result;
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    result.add(graph.terms[i]);
                }
                return result;
            }
        };
        return merger.merger();
    }

    public static boolean isRuleWord(String word) {
        char c = '\u0000';
        for (int i = 0; i < word.length(); ++i) {
            c = word.charAt(i);
            if (c == '\u00b7' || c >= '\u0100' && !filter.contains(Character.valueOf(c)) && (c = WordAlert.CharCover((char)word.charAt(i))) <= '\u0000') continue;
            return true;
        }
        return false;
    }

    public NlpAnalysis setCrfModel(SplitWord splitWord) {
        this.splitWord = splitWord;
        return this;
    }

    public NlpAnalysis setLearnTool(LearnTool learn) {
        this.learn = learn;
        return this;
    }

    public NlpAnalysis() {
    }

    public NlpAnalysis(Reader reader) {
        super.resetContent(new AnsjReader(reader));
    }

    public static Result parse(String str) {
        return new NlpAnalysis().parseStr(str);
    }

    public static Result parse(String str, Forest ... forests) {
        return new NlpAnalysis().setForests(forests).parseStr(str);
    }

    static {
        filter.add(Character.valueOf(':'));
        filter.add(Character.valueOf(' '));
        filter.add(Character.valueOf('\uff1a'));
        filter.add(Character.valueOf('\u3000'));
        filter.add(Character.valueOf('\uff0c'));
        filter.add(Character.valueOf('\u201d'));
        filter.add(Character.valueOf('\u201c'));
        filter.add(Character.valueOf('\uff1f'));
        filter.add(Character.valueOf('\u3002'));
        filter.add(Character.valueOf('\uff01'));
        filter.add(Character.valueOf('\u3002'));
        filter.add(Character.valueOf(','));
        filter.add(Character.valueOf('.'));
        filter.add(Character.valueOf('\u3001'));
        filter.add(Character.valueOf('\\'));
        filter.add(Character.valueOf('\uff1b'));
        filter.add(Character.valueOf(';'));
        filter.add(Character.valueOf('\uff1f'));
        filter.add(Character.valueOf('?'));
        filter.add(Character.valueOf('!'));
        filter.add(Character.valueOf('\"'));
        filter.add(Character.valueOf('\uff08'));
        filter.add(Character.valueOf('\uff09'));
        filter.add(Character.valueOf('('));
        filter.add(Character.valueOf(')'));
        filter.add(Character.valueOf('\u2026'));
        filter.add(Character.valueOf('\u2026'));
        filter.add(Character.valueOf('\u2014'));
        filter.add(Character.valueOf('-'));
        filter.add(Character.valueOf('\uff0d'));
        filter.add(Character.valueOf('\u2014'));
        filter.add(Character.valueOf('\u300a'));
        filter.add(Character.valueOf('\u300b'));
    }
}

