/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.DicReader;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.name.PersonAttrLibrary;
import org.nlpcn.commons.lang.dat.DoubleArrayTire;
import org.nlpcn.commons.lang.dat.Item;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class DATDictionary {
    private static final Log LOG = LogFactory.getLog(DATDictionary.class);
    private static final DoubleArrayTire DAT = DATDictionary.loadDAT();
    public static int arrayLength = DATDictionary.DAT.arrayLength;

    private static DoubleArrayTire loadDAT() {
        long start = System.currentTimeMillis();
        try {
            DoubleArrayTire dat = DoubleArrayTire.loadText((InputStream)DicReader.getInputStream("core.dic"), AnsjItem.class);
            DATDictionary.personNameFull(dat);
            for (Item item : dat.getDAT()) {
                if (item == null || item.getName() == null || item.getStatus() >= 2) continue;
                item.setName(null);
            }
            LOG.info("init core library ok use time : " + (System.currentTimeMillis() - start));
            return dat;
        }
        catch (InstantiationException e) {
            LOG.warn("\u65e0\u6cd5\u5b9e\u4f8b\u5316", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("\u975e\u6cd5\u8bbf\u95ee", (Throwable)e);
        }
        catch (NumberFormatException e) {
            LOG.warn("\u6570\u5b57\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("IO\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    private static void personNameFull(DoubleArrayTire dat) throws NumberFormatException, IOException {
        HashMap<String, PersonNatureAttr> personMap = new PersonAttrLibrary().getPersonMap();
        AnsjItem ansjItem = null;
        Set<Map.Entry<String, PersonNatureAttr>> entrySet = personMap.entrySet();
        int c = 0;
        String temp = null;
        for (Map.Entry<String, PersonNatureAttr> entry : entrySet) {
            temp = entry.getKey();
            if (temp.length() == 1 && (ansjItem = (AnsjItem)dat.getDAT()[temp.charAt(0)]) == null) {
                ansjItem = new AnsjItem();
                ansjItem.setBase(c);
                ansjItem.setCheck(-1);
                ansjItem.setStatus((byte)3);
                ansjItem.setName(temp);
                dat.getDAT()[temp.charAt((int)0)] = ansjItem;
            } else {
                ansjItem = (AnsjItem)dat.getItem(temp);
            }
            if (ansjItem == null) continue;
            if (ansjItem.termNatures == null) {
                ansjItem.termNatures = temp.length() == 1 && temp.charAt(0) < '\u0100' ? TermNatures.NULL : new TermNatures(TermNature.NR);
            }
            ansjItem.termNatures.setPersonNatureAttr(entry.getValue());
        }
    }

    public static int status(char c) {
        Item item = DAT.getDAT()[c];
        if (item == null) {
            return 0;
        }
        return item.getStatus();
    }

    public static boolean isInSystemDic(String word) {
        Item item = DAT.getItem(word);
        return item != null && item.getStatus() > 1;
    }

    public static AnsjItem getItem(int index) {
        AnsjItem item = (AnsjItem)DAT.getItem(index);
        if (item == null) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static AnsjItem getItem(String str) {
        AnsjItem item = (AnsjItem)DAT.getItem(str);
        if (item == null || item.getStatus() < 2) {
            return AnsjItem.NULL;
        }
        return item;
    }

    public static int getId(String str) {
        return DAT.getId(str);
    }
}

