/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.library.NatureLibrary;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.recognition.arrimpl.PersonRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.GetWord;
import org.nlpcn.commons.lang.tire.domain.Forest;

public class DicAnalysis
extends Analysis {
    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                this.userDefineRecognition(graph, DicAnalysis.this.forests);
                graph.walkPath();
                if (DicAnalysis.this.isNumRecognition) {
                    new NumRecognition(DicAnalysis.this.isQuantifierRecognition && graph.hasNumQua).recognition(graph);
                }
                if (graph.hasPerson && DicAnalysis.this.isNameRecognition) {
                    new PersonRecognition().recognition(graph);
                    graph.walkPathByScore();
                    graph.walkPathByScore();
                }
                return this.getResult();
            }

            private void userDefineRecognition(Graph graph2, Forest ... forests) {
                if (forests == null) {
                    return;
                }
                int beginOff = graph2.terms[0].getOffe();
                Forest forest = null;
                for (int i = forests.length - 1; i >= 0; --i) {
                    forest = forests[i];
                    if (forest == null) continue;
                    GetWord word = forest.getWord(graph2.chars);
                    String temp = null;
                    int tempFreq = 50;
                    while ((temp = word.getAllWords()) != null) {
                        if (graph2.terms[word.offe] == null) continue;
                        Term tempTerm = graph2.terms[word.offe];
                        tempFreq = this.getInt(((String[])word.getParam())[1], 50);
                        if (graph2.terms[word.offe] != null && graph2.terms[word.offe].getName().equals(temp)) {
                            tempTerm.termNatures().allFreq = tempFreq;
                            tempTerm.termNatures().nature = NatureLibrary.getNature(((String[])word.getParam())[0]);
                            tempTerm.setNature(tempTerm.termNatures().nature);
                            continue;
                        }
                        Term term = new Term(temp, beginOff + word.offe, ((String[])word.getParam())[0], tempFreq);
                        term.selfScore(-1.0 * Math.pow(Math.log(tempFreq), temp.length()));
                        TermUtil.insertTerm(graph2.terms, term, TermUtil.InsertTermType.REPLACE);
                    }
                }
                graph2.rmLittlePath();
                graph2.walkPathByScore();
                graph2.rmLittlePath();
            }

            private int getInt(String str, int def) {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    return def;
                }
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    Term term = graph.terms[i];
                    if (term == null) continue;
                    DicAnalysis.this.setIsNewWord(term);
                    result.add(term);
                }
                DicAnalysis.this.setRealName(graph, result);
                return result;
            }
        };
        return merger.merger();
    }

    public DicAnalysis() {
    }

    public DicAnalysis(Reader reader) {
        super.resetContent(new AnsjReader(reader));
    }

    public static Result parse(String str) {
        return new DicAnalysis().parseStr(str);
    }

    public static Result parse(String str, Forest ... forests) {
        return new DicAnalysis().setForests(forests).parseStr(str);
    }
}

