/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.Random;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

public class WeightedRandomLoadBalancer
extends WeightedLoadBalancer {
    private final Random rnd = new Random();
    private final int distributionRatioSum;
    private int runtimeRatioSum;

    public WeightedRandomLoadBalancer(List<Integer> distributionRatioList) {
        super(distributionRatioList);
        int sum = 0;
        for (Integer distributionRatio : distributionRatioList) {
            sum += distributionRatio.intValue();
        }
        this.runtimeRatioSum = this.distributionRatioSum = sum;
    }

    @Override
    protected Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        int index;
        this.lastIndex = index = this.selectProcessIndex();
        return processors.get(index);
    }

    public int selectProcessIndex() {
        if (this.runtimeRatioSum == 0) {
            for (DistributionRatio distributionRatio : this.getRuntimeRatios()) {
                int weight = distributionRatio.getDistributionWeight();
                distributionRatio.setRuntimeWeight(weight);
            }
            this.runtimeRatioSum = this.distributionRatioSum;
        }
        DistributionRatio selected = null;
        int randomWeight = this.rnd.nextInt(this.runtimeRatioSum);
        int choiceWeight = 0;
        for (DistributionRatio distributionRatio : this.getRuntimeRatios()) {
            if (randomWeight >= (choiceWeight += distributionRatio.getRuntimeWeight())) continue;
            selected = distributionRatio;
            break;
        }
        selected.setRuntimeWeight(selected.getRuntimeWeight() - 1);
        --this.runtimeRatioSum;
        return selected.getProcessorPosition();
    }
}

