/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class WindowUpdateBodyParser
extends ControlFrameBodyParser {
    private final ControlFrameParser controlFrameParser;
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;
    private int windowDelta;

    public WindowUpdateBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block6: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.WINDOW_DELTA;
                        continue block6;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block6;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block6;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.WINDOW_DELTA;
                    continue block6;
                }
                case WINDOW_DELTA: {
                    if (buffer.remaining() >= 4) {
                        this.windowDelta = buffer.getInt() & Integer.MAX_VALUE;
                        this.onWindowUpdate();
                        return true;
                    }
                    this.state = State.WINDOW_DELTA_BYTES;
                    this.cursor = 4;
                    continue block6;
                }
                case WINDOW_DELTA_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.windowDelta += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block6;
                    this.windowDelta &= Integer.MAX_VALUE;
                    this.onWindowUpdate();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onWindowUpdate() {
        WindowUpdateFrame frame = new WindowUpdateFrame(this.controlFrameParser.getVersion(), this.streamId, this.windowDelta);
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
        this.windowDelta = 0;
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        WINDOW_DELTA,
        WINDOW_DELTA_BYTES;

    }
}

