/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.aio;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFile;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.jlibaio.LibaioFile;
import org.apache.activemq.artemis.jlibaio.SubmitInfo;
import org.apache.activemq.artemis.jlibaio.util.CallbackCache;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.jboss.logging.Logger;

public final class AIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    private static final Logger logger = Logger.getLogger(AIOSequentialFileFactory.class);
    private final ReuseBuffersController buffersControl = new ReuseBuffersController();
    private volatile boolean reuseBuffers = true;
    private Thread pollerThread;
    volatile LibaioContext<AIOSequentialCallback> libaioContext;
    private final CallbackCache<AIOSequentialCallback> callbackPool;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private static final String AIO_TEST_FILE = ".aio-test";

    public AIOSequentialFileFactory(File journalDir, int maxIO) {
        this(journalDir, 501760, 500000, maxIO, false, null, null);
    }

    public AIOSequentialFileFactory(File journalDir, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, 501760, 500000, maxIO, false, listener, null);
    }

    public AIOSequentialFileFactory(File journalDir, int bufferSize, int bufferTimeout, int maxIO, boolean logRates) {
        this(journalDir, bufferSize, bufferTimeout, maxIO, logRates, null, null);
    }

    public AIOSequentialFileFactory(File journalDir, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener listener, CriticalAnalyzer analyzer) {
        super(journalDir, true, bufferSize, bufferTimeout, maxIO, logRates, listener, analyzer);
        this.callbackPool = new CallbackCache(maxIO);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"New AIO File Created");
        }
    }

    public AIOSequentialCallback getCallback() {
        AIOSequentialCallback callback = (AIOSequentialCallback)this.callbackPool.get();
        if (callback == null) {
            callback = new AIOSequentialCallback();
        }
        return callback;
    }

    public void enableBufferReuse() {
        this.reuseBuffers = true;
    }

    public void disableBufferReuse() {
        this.reuseBuffers = false;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new AIOSequentialFile(this, this.bufferSize, this.bufferTimeout, this.journalDir, fileName, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return true;
    }

    public static boolean isSupported() {
        return LibaioContext.isLoaded();
    }

    public static boolean isSupported(File journalPath) {
        if (!AIOSequentialFileFactory.isSupported()) {
            return false;
        }
        File aioTestFile = new File(journalPath, AIO_TEST_FILE);
        try {
            int fd = LibaioContext.open((String)aioTestFile.getAbsolutePath(), (boolean)true);
            LibaioContext.close((int)fd);
            aioTestFile.delete();
        }
        catch (Exception e) {
            try {
                if (!aioTestFile.exists() && !aioTestFile.createNewFile()) {
                    return true;
                }
                if (!aioTestFile.delete()) {
                    return true;
                }
            }
            catch (Exception ie) {
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int blocks = size / this.getAlignment();
        if (size % this.getAlignment() != 0) {
            ++blocks;
        }
        ByteBuffer buffer = LibaioContext.newAlignedBuffer((int)(blocks * this.getAlignment()), (int)this.getAlignment());
        buffer.limit(size);
        return buffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        LibaioContext.freeBuffer((ByteBuffer)buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (size % this.getAlignment() != 0) {
            size = (size / this.getAlignment() + 1) * this.getAlignment();
        }
        return this.buffersControl.newBuffer(size);
    }

    @Override
    public void clearBuffer(ByteBuffer directByteBuffer) {
        directByteBuffer.position(0);
        this.libaioContext.memsetBuffer(directByteBuffer);
    }

    @Override
    public int getAlignment() {
        if (this.alignment < 0) {
            File checkFile = null;
            try {
                this.journalDir.mkdirs();
                checkFile = File.createTempFile("journalCheck", ".tmp", this.journalDir);
                checkFile.mkdirs();
                checkFile.createNewFile();
                this.alignment = LibaioContext.getBlockSize((File)checkFile);
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
                this.alignment = 512;
            }
            finally {
                if (checkFile != null) {
                    checkFile.delete();
                }
            }
        }
        return this.alignment;
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        ByteBuffer newbuffer = this.newBuffer(bytes.length);
        newbuffer.put(bytes);
        return newbuffer;
    }

    @Override
    public int calculateBlockSize(int position) {
        int alignment = this.getAlignment();
        int pos = (position / alignment + (position % alignment != 0 ? 1 : 0)) * alignment;
        return pos;
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        LibaioContext.freeBuffer((ByteBuffer)buffer);
    }

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            super.start();
            this.libaioContext = new LibaioContext(this.maxIO, true, this.dataSync);
            this.running.set(true);
            this.pollerThread = new PollerThread();
            this.pollerThread.start();
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.buffersControl.stop();
            this.libaioContext.close();
            this.libaioContext = null;
            if (this.pollerThread != null) {
                try {
                    this.pollerThread.join(60000L);
                    if (this.pollerThread.isAlive()) {
                        ActiveMQJournalLogger.LOGGER.timeoutOnPollerShutdown(new Exception("trace"));
                    }
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
            super.stop();
        }
    }

    public String toString() {
        return AIOSequentialFileFactory.class.getSimpleName() + "(buffersControl.stopped=" + this.buffersControl.stopped + "):" + super.toString();
    }

    private class ReuseBuffersController {
        private volatile long bufferReuseLastTime = System.currentTimeMillis();
        private final ConcurrentLinkedQueue<ByteBuffer> reuseBuffersQueue = new ConcurrentLinkedQueue();
        private boolean stopped = false;
        private int alignedBufferSize = 0;

        private ReuseBuffersController() {
        }

        private int getAlignedBufferSize() {
            if (this.alignedBufferSize == 0) {
                this.alignedBufferSize = AIOSequentialFileFactory.this.calculateBlockSize(AIOSequentialFileFactory.this.bufferSize);
            }
            return this.alignedBufferSize;
        }

        public ByteBuffer newBuffer(int size) {
            if (AIOSequentialFileFactory.this.bufferSize > 0 && System.currentTimeMillis() - this.bufferReuseLastTime > 10000L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Clearing reuse buffers queue with " + this.reuseBuffersQueue.size() + " elements"));
                }
                this.bufferReuseLastTime = System.currentTimeMillis();
                this.clearPoll();
            }
            if (size > this.getAlignedBufferSize()) {
                return LibaioContext.newAlignedBuffer((int)size, (int)AIOSequentialFileFactory.this.getAlignment());
            }
            int alignedSize = size < this.getAlignedBufferSize() ? this.getAlignedBufferSize() : AIOSequentialFileFactory.this.calculateBlockSize(size);
            ByteBuffer buffer = this.reuseBuffersQueue.poll();
            if (buffer == null) {
                buffer = LibaioContext.newAlignedBuffer((int)alignedSize, (int)AIOSequentialFileFactory.this.getAlignment());
                buffer.limit(AIOSequentialFileFactory.this.calculateBlockSize(size));
            } else {
                AIOSequentialFileFactory.this.clearBuffer(buffer);
                buffer.limit(AIOSequentialFileFactory.this.calculateBlockSize(size));
            }
            buffer.rewind();
            return buffer;
        }

        public synchronized void stop() {
            this.stopped = true;
            this.clearPoll();
        }

        public synchronized void clearPoll() {
            ByteBuffer reusedBuffer;
            while ((reusedBuffer = this.reuseBuffersQueue.poll()) != null) {
                AIOSequentialFileFactory.this.releaseBuffer(reusedBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferDone(ByteBuffer buffer) {
            ReuseBuffersController reuseBuffersController = this;
            synchronized (reuseBuffersController) {
                if (this.stopped) {
                    AIOSequentialFileFactory.this.releaseBuffer(buffer);
                } else {
                    this.bufferReuseLastTime = System.currentTimeMillis();
                    if (buffer.capacity() == this.getAlignedBufferSize()) {
                        this.reuseBuffersQueue.offer(buffer);
                    } else {
                        AIOSequentialFileFactory.this.releaseBuffer(buffer);
                    }
                }
            }
        }
    }

    private class PollerThread
    extends Thread {
        private PollerThread() {
            super("Apache ActiveMQ Artemis libaio poller");
        }

        @Override
        public void run() {
            while (AIOSequentialFileFactory.this.running.get()) {
                try {
                    AIOSequentialFileFactory.this.libaioContext.poll();
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.warn(e.getMessage(), e);
                    AIOSequentialFileFactory.this.onIOError((Exception)new ActiveMQException("Error on libaio poll"), e.getMessage(), null);
                }
            }
        }
    }

    public class AIOSequentialCallback
    implements SubmitInfo,
    Runnable,
    Comparable<AIOSequentialCallback> {
        IOCallback callback;
        boolean error = false;
        AIOSequentialFile sequentialFile;
        ByteBuffer buffer;
        LibaioFile libaioFile;
        String errorMessage;
        int errorCode = -1;
        long writeSequence;
        boolean releaseBuffer;
        long position;
        int bytes;

        public String toString() {
            return "AIOSequentialCallback{error=" + this.error + ", errorMessage='" + this.errorMessage + '\'' + ", errorCode=" + this.errorCode + ", writeSequence=" + this.writeSequence + ", releaseBuffer=" + this.releaseBuffer + ", position=" + this.position + '}';
        }

        public AIOSequentialCallback initWrite(long positionToWrite, int bytesToWrite) {
            this.position = positionToWrite;
            this.bytes = bytesToWrite;
            return this;
        }

        @Override
        public void run() {
            try {
                this.libaioFile.write(this.position, this.bytes, this.buffer, (SubmitInfo)this);
            }
            catch (IOException e) {
                this.callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
                AIOSequentialFileFactory.this.onIOError(e, "Failed to write to file", this.sequentialFile);
            }
        }

        @Override
        public int compareTo(AIOSequentialCallback other) {
            if (this == other || this.writeSequence == other.writeSequence) {
                return 0;
            }
            if (other.writeSequence < this.writeSequence) {
                return 1;
            }
            return -1;
        }

        public AIOSequentialCallback init(long writeSequence, IOCallback IOCallback2, LibaioFile libaioFile, AIOSequentialFile sequentialFile, ByteBuffer usedBuffer, boolean releaseBuffer) {
            this.callback = IOCallback2;
            this.sequentialFile = sequentialFile;
            this.error = false;
            this.buffer = usedBuffer;
            this.libaioFile = libaioFile;
            this.writeSequence = writeSequence;
            this.errorMessage = null;
            this.releaseBuffer = releaseBuffer;
            return this;
        }

        public void onError(int errno, String message) {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("AIO on error issued. Error(code: " + errno + " msg: " + message + ")"));
            }
            this.error = true;
            this.errorCode = errno;
            this.errorMessage = message;
        }

        public void done() {
            this.sequentialFile.done(this);
        }

        public void sequentialDone() {
            if (this.error) {
                this.callback.onError(this.errorCode, this.errorMessage);
                AIOSequentialFileFactory.this.onIOError((Exception)new ActiveMQException(this.errorCode, this.errorMessage), this.errorMessage, null);
                this.errorMessage = null;
            } else {
                if (this.callback != null) {
                    this.callback.done();
                }
                if (this.buffer != null && AIOSequentialFileFactory.this.reuseBuffers && this.releaseBuffer) {
                    AIOSequentialFileFactory.this.buffersControl.bufferDone(this.buffer);
                }
                AIOSequentialFileFactory.this.callbackPool.put((SubmitInfo)this);
            }
        }
    }
}

