/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public final class JdbcNodeManager
extends NodeManager {
    private static final Logger LOGGER = Logger.getLogger(JdbcNodeManager.class);
    private static final long MAX_PAUSE_MILLIS = 2000L;
    private final Supplier<? extends SharedStateManager> sharedStateManagerFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledLiveLockFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledBackupLockFactory;
    private SharedStateManager sharedStateManager;
    private ScheduledLeaseLock scheduledLiveLock;
    private ScheduledLeaseLock scheduledBackupLock;
    private final long lockAcquisitionTimeoutMillis;
    private volatile boolean interrupted = false;
    private final LeaseLock.Pauser pauser;
    private final IOCriticalErrorListener ioCriticalErrorListener;

    public static JdbcNodeManager with(DatabaseStorageConfiguration configuration, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        JdbcNodeManager.validateTimeoutConfiguration(configuration);
        if (configuration.getDataSource() != null) {
            Object sqlProviderFactory = configuration.getSqlProviderFactory() != null ? configuration.getSqlProviderFactory() : new PropertySQLProvider.Factory(configuration.getDataSource());
            String brokerId = UUID.randomUUID().toString();
            return JdbcNodeManager.usingDataSource(brokerId, configuration.getJdbcNetworkTimeout(), configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getDataSource(), sqlProviderFactory.create(configuration.getNodeManagerStoreTableName(), SQLProvider.DatabaseStoreType.NODE_MANAGER), scheduledExecutorService, executorFactory, ioCriticalErrorListener);
        }
        SQLProvider sqlProvider = JDBCUtils.getSQLProvider((String)configuration.getJdbcDriverClassName(), (String)configuration.getNodeManagerStoreTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.NODE_MANAGER);
        String brokerId = UUID.randomUUID().toString();
        return JdbcNodeManager.usingConnectionUrl(brokerId, configuration.getJdbcNetworkTimeout(), configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getJdbcConnectionUrl(), configuration.getJdbcDriverClassName(), sqlProvider, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    private static JdbcNodeManager usingDataSource(String brokerId, int networkTimeoutMillis, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, DataSource dataSource, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingDataSource(brokerId, networkTimeoutMillis, (Executor)(executorFactory == null ? null : executorFactory.getExecutor()), lockExpirationMillis, dataSource, provider), lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    private static JdbcNodeManager usingConnectionUrl(String brokerId, int networkTimeoutMillis, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, String jdbcUrl, String driverClass, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingConnectionUrl(brokerId, networkTimeoutMillis, (Executor)(executorFactory == null ? null : executorFactory.getExecutor()), lockExpirationMillis, jdbcUrl, driverClass, provider), lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory, ioCriticalErrorListener);
    }

    private static void validateTimeoutConfiguration(DatabaseStorageConfiguration configuration) {
        long lockExpiration = configuration.getJdbcLockExpirationMillis();
        if (lockExpiration <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-expiration should be positive");
        }
        long lockRenewPeriod = configuration.getJdbcLockRenewPeriodMillis();
        if (lockRenewPeriod <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be positive");
        }
        if (lockRenewPeriod >= lockExpiration) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be < jdbc-lock-expiration");
        }
        int networkTimeout = configuration.getJdbcNetworkTimeout();
        if (networkTimeout >= 0) {
            if ((long)networkTimeout > lockExpiration) {
                LOGGER.warn((Object)"jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
            }
        } else {
            LOGGER.warn((Object)"jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
        }
    }

    private JdbcNodeManager(Supplier<? extends SharedStateManager> sharedStateManagerFactory, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, IOCriticalErrorListener ioCriticalErrorListener) {
        super(false, null);
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
        this.pauser = LeaseLock.Pauser.sleep(Math.min(lockRenewPeriodMillis, 2000L), TimeUnit.MILLISECONDS);
        this.sharedStateManagerFactory = sharedStateManagerFactory;
        this.scheduledLiveLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "live", this.sharedStateManager.liveLock(), lockRenewPeriodMillis, ioCriticalErrorListener);
        this.scheduledBackupLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "backup", this.sharedStateManager.backupLock(), lockRenewPeriodMillis, ioCriticalErrorListener);
        this.ioCriticalErrorListener = ioCriticalErrorListener;
        this.sharedStateManager = null;
        this.scheduledLiveLock = null;
        this.scheduledBackupLock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            JdbcNodeManager jdbcNodeManager = this;
            synchronized (jdbcNodeManager) {
                if (this.isStarted()) {
                    return;
                }
                this.sharedStateManager = this.sharedStateManagerFactory.get();
                LOGGER.debug((Object)"setup sharedStateManager on start");
                org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.setup(() -> ((UUIDGenerator)UUIDGenerator.getInstance()).generateUUID());
                this.setUUID(nodeId);
                this.scheduledLiveLock = this.scheduledLiveLockFactory.get();
                this.scheduledBackupLock = this.scheduledBackupLockFactory.get();
                super.start();
            }
        }
        catch (IllegalStateException e) {
            this.sharedStateManager = null;
            this.scheduledLiveLock = null;
            this.scheduledBackupLock = null;
            if (this.ioCriticalErrorListener != null) {
                this.ioCriticalErrorListener.onIOException((Throwable)e, "Failed to setup the JdbcNodeManager", null);
            }
            throw e;
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            try {
                this.scheduledLiveLock.stop();
                this.scheduledBackupLock.stop();
            }
            finally {
                super.stop();
                this.sharedStateManager.close();
                this.sharedStateManager = null;
                this.scheduledLiveLock = null;
                this.scheduledBackupLock = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        LOGGER.debug((Object)"ENTER isAwaitingFailback");
        try {
            boolean bl = this.readSharedState() == SharedStateManager.State.FAILING_BACK;
            return bl;
        }
        finally {
            LOGGER.debug((Object)"EXIT isAwaitingFailback");
        }
    }

    @Override
    public boolean isBackupLive() throws Exception {
        LOGGER.debug((Object)"ENTER isBackupLive");
        try {
            boolean bl = this.scheduledLiveLock.lock().isHeld();
            return bl;
        }
        finally {
            LOGGER.debug((Object)"EXIT isBackupLive");
        }
    }

    @Override
    public void stopBackup() throws Exception {
        LOGGER.debug((Object)"ENTER stopBackup");
        try {
            if (this.scheduledBackupLock.isStarted()) {
                LOGGER.debug((Object)"scheduledBackupLock is running: stop it and release backup lock");
                this.scheduledBackupLock.stop();
                this.scheduledBackupLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledBackupLock is not running");
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT stopBackup");
        }
    }

    @Override
    public void interrupt() {
        LOGGER.debug((Object)"ENTER interrupted");
        this.interrupted = true;
        LOGGER.debug((Object)"EXIT interrupted");
    }

    @Override
    public void releaseBackup() throws Exception {
        LOGGER.debug((Object)"ENTER releaseBackup");
        try {
            if (this.scheduledBackupLock.isStarted()) {
                LOGGER.debug((Object)"scheduledBackupLock is running: stop it and release backup lock");
                this.scheduledBackupLock.stop();
                this.scheduledBackupLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledBackupLock is not running");
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT releaseBackup");
        }
    }

    private void lock(LeaseLock lock) throws Exception {
        LeaseLock.AcquireResult acquireResult = lock.tryAcquire(this.lockAcquisitionTimeoutMillis, this.pauser, () -> !this.interrupted);
        switch (acquireResult) {
            case Timeout: {
                throw new Exception("timed out waiting for lock");
            }
            case Exit: {
                this.interrupted = false;
                throw new InterruptedException("LeaseLock was interrupted");
            }
            case Done: {
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)acquireResult) + " not managed"));
            }
        }
    }

    private void checkInterrupted(Supplier<String> message) throws InterruptedException {
        if (this.interrupted) {
            this.interrupted = false;
            throw new InterruptedException(message.get());
        }
    }

    private void renewLiveLockIfNeeded(long acquiredOn) {
        long acquiredMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - acquiredOn);
        if (acquiredMillis > this.scheduledLiveLock.renewPeriodMillis() && !this.scheduledLiveLock.lock().renew()) {
            IllegalStateException e = new IllegalStateException("live lock can't be renewed");
            this.ioCriticalErrorListener.onIOException((Throwable)e, "live lock can't be renewed", null);
            throw e;
        }
    }

    private boolean lockLiveAndCheckLiveState() throws Exception {
        SharedStateManager.State stateWhileLocked;
        this.lock(this.scheduledLiveLock.lock());
        long acquiredOn = System.nanoTime();
        boolean liveWhileLocked = false;
        try {
            stateWhileLocked = this.readSharedState();
        }
        catch (Throwable t) {
            LOGGER.error((Object)"error while holding the live node lock and tried to read the shared state", t);
            this.scheduledLiveLock.lock().release();
            throw t;
        }
        if (stateWhileLocked == SharedStateManager.State.LIVE) {
            this.renewLiveLockIfNeeded(acquiredOn);
            liveWhileLocked = true;
        } else {
            LOGGER.debugf("state is %s while holding the live lock: releasing live lock", (Object)stateWhileLocked);
            this.scheduledLiveLock.lock().release();
        }
        return liveWhileLocked;
    }

    @Override
    public void awaitLiveNode() throws Exception {
        LOGGER.debug((Object)"ENTER awaitLiveNode");
        try {
            boolean liveWhileLocked = false;
            while (!liveWhileLocked) {
                SharedStateManager.State state = this.readSharedState();
                if (state == SharedStateManager.State.LIVE) {
                    liveWhileLocked = this.lockLiveAndCheckLiveState();
                } else {
                    LOGGER.debugf("state while awaiting live node: %s", (Object)state);
                }
                if (liveWhileLocked) continue;
                this.checkInterrupted(() -> "awaitLiveNode got interrupted!");
                this.pauser.idle();
            }
            LOGGER.debugf("acquired live node lock while state is %s: starting scheduledLiveLock", (Object)SharedStateManager.State.LIVE);
            this.scheduledLiveLock.start();
        }
        finally {
            LOGGER.debug((Object)"EXIT awaitLiveNode");
        }
    }

    @Override
    public void startBackup() throws Exception {
        LOGGER.debug((Object)"ENTER startBackup");
        try {
            ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
            this.lock(this.scheduledBackupLock.lock());
            this.scheduledBackupLock.start();
            ActiveMQServerLogger.LOGGER.gotBackupLock();
            if (this.getUUID() == null) {
                this.readNodeId();
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT startBackup");
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws Exception {
        LOGGER.debug((Object)"ENTER startLiveNode");
        try {
            this.setFailingBack();
            String timeoutMessage = this.lockAcquisitionTimeoutMillis == -1L ? "indefinitely" : this.lockAcquisitionTimeoutMillis + " milliseconds";
            ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
            this.lock(this.scheduledLiveLock.lock());
            this.scheduledLiveLock.start();
            ActiveMQServerLogger.LOGGER.obtainedLiveLock();
            CleaningActivateCallback cleaningActivateCallback = new CleaningActivateCallback(){

                @Override
                public void activationComplete() {
                    LOGGER.debug((Object)"ENTER activationComplete");
                    try {
                        JdbcNodeManager.this.setLive();
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                    }
                    finally {
                        LOGGER.debug((Object)"EXIT activationComplete");
                    }
                }
            };
            return cleaningActivateCallback;
        }
        finally {
            LOGGER.debug((Object)"EXIT startLiveNode");
        }
    }

    @Override
    public void pauseLiveServer() throws Exception {
        block5: {
            LOGGER.debug((Object)"ENTER pauseLiveServer");
            try {
                if (this.scheduledLiveLock.isStarted()) {
                    LOGGER.debug((Object)"scheduledLiveLock is running: set paused shared state, stop it and release live lock");
                    this.setPaused();
                    this.scheduledLiveLock.stop();
                    this.scheduledLiveLock.lock().release();
                    break block5;
                }
                LOGGER.debug((Object)"scheduledLiveLock is not running: try renew live lock");
                if (this.scheduledLiveLock.lock().renew()) {
                    LOGGER.debug((Object)"live lock renewed: set paused shared state and release live lock");
                    this.setPaused();
                    this.scheduledLiveLock.lock().release();
                    break block5;
                }
                IllegalStateException e = new IllegalStateException("live lock can't be renewed");
                this.ioCriticalErrorListener.onIOException((Throwable)e, "live lock can't be renewed on pauseLiveServer", null);
                throw e;
            }
            finally {
                LOGGER.debug((Object)"EXIT pauseLiveServer");
            }
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        LOGGER.debug((Object)"ENTER crashLiveServer");
        try {
            if (this.scheduledLiveLock.isStarted()) {
                LOGGER.debug((Object)"scheduledLiveLock is running: request stop it and release live lock");
                this.scheduledLiveLock.stop();
                this.scheduledLiveLock.lock().release();
            } else {
                LOGGER.debug((Object)"scheduledLiveLock is not running");
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT crashLiveServer");
        }
    }

    @Override
    public void awaitLiveStatus() {
        LOGGER.debug((Object)"ENTER awaitLiveStatus");
        try {
            while (this.readSharedState() != SharedStateManager.State.LIVE) {
                this.pauser.idle();
            }
        }
        finally {
            LOGGER.debug((Object)"EXIT awaitLiveStatus");
        }
    }

    private void setLive() {
        this.writeSharedState(SharedStateManager.State.LIVE);
    }

    private void setFailingBack() {
        this.writeSharedState(SharedStateManager.State.FAILING_BACK);
    }

    private void setPaused() {
        this.writeSharedState(SharedStateManager.State.PAUSED);
    }

    private void writeSharedState(SharedStateManager.State state) {
        LOGGER.debugf("writeSharedState state = %s", (Object)state);
        this.sharedStateManager.writeState(state);
    }

    private SharedStateManager.State readSharedState() {
        SharedStateManager.State state = this.sharedStateManager.readState();
        LOGGER.debugf("readSharedState state = %s", (Object)state);
        return state;
    }

    @Override
    public SimpleString readNodeId() {
        org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.readNodeId();
        LOGGER.debugf("readNodeId nodeId = %s", (Object)nodeId);
        this.setUUID(nodeId);
        return this.getNodeId();
    }
}

