/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.framework.recipes.shared.SharedCountListener;
import org.apache.curator.framework.recipes.shared.SharedCountReader;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessSemaphoreV2 {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InterProcessMutex lock;
    private final CuratorFramework client;
    private final String leasesPath;
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            InterProcessSemaphoreV2.this.notifyFromWatcher();
        }
    };
    private volatile byte[] nodeData;
    private volatile int maxLeases;
    private static final String LOCK_PARENT = "locks";
    private static final String LEASE_PARENT = "leases";
    private static final String LEASE_BASE_NAME = "lease-";

    public InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases) {
        this(client, path, maxLeases, null);
    }

    public InterProcessSemaphoreV2(CuratorFramework client, String path, SharedCountReader count) {
        this(client, path, 0, count);
    }

    private InterProcessSemaphoreV2(CuratorFramework client, String path, int maxLeases, SharedCountReader count) {
        this.client = client;
        this.lock = new InterProcessMutex(client, ZKPaths.makePath((String)path, (String)LOCK_PARENT));
        this.maxLeases = count != null ? count.getCount() : maxLeases;
        this.leasesPath = ZKPaths.makePath((String)path, (String)LEASE_PARENT);
        if (count != null) {
            count.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphoreV2.this.maxLeases = newCount;
                }

                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                }
            });
        }
    }

    public void setNodeData(byte[] nodeData) {
        this.nodeData = nodeData != null ? Arrays.copyOf(nodeData, nodeData.length) : null;
    }

    public Collection<String> getParticipantNodes() throws Exception {
        return (Collection)this.client.getChildren().forPath(ZKPaths.makePath((String)this.leasesPath, (String)LEASE_BASE_NAME));
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            Closeables.closeQuietly((Closeable)l);
        }
    }

    public void returnLease(Lease lease) {
        Closeables.closeQuietly((Closeable)lease);
    }

    public Lease acquire() throws Exception {
        Collection<Lease> leases = this.acquire(1, 0L, null);
        return leases.iterator().next();
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        return this.acquire(qty, 0L, null);
    }

    public Lease acquire(long time, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.acquire(1, time, unit);
        return leases != null ? leases.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Lease> acquire(int qty, long time, TimeUnit unit) throws Exception {
        long startMs = System.currentTimeMillis();
        boolean hasWait = unit != null;
        long waitMs = hasWait ? TimeUnit.MILLISECONDS.convert(time, unit) : 0L;
        Preconditions.checkArgument((qty > 0 ? 1 : 0) != 0, (Object)"qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean success = false;
        try {
            block13: while (qty-- > 0) {
                if (!this.client.isStarted()) {
                    Collection<Lease> collection = null;
                    return collection;
                }
                if (hasWait) {
                    long thisWaitMs = this.getThisWaitMs(startMs, waitMs);
                    if (!this.lock.acquire(thisWaitMs, TimeUnit.MILLISECONDS)) {
                        Collection<Lease> collection = null;
                        return collection;
                    }
                } else {
                    this.lock.acquire();
                }
                try {
                    PathAndBytesable createBuilder = (PathAndBytesable)this.client.create().creatingParentsIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL);
                    String path = this.nodeData != null ? (String)createBuilder.forPath(ZKPaths.makePath((String)this.leasesPath, (String)LEASE_BASE_NAME), this.nodeData) : (String)createBuilder.forPath(ZKPaths.makePath((String)this.leasesPath, (String)LEASE_BASE_NAME));
                    String nodeName = ZKPaths.getNodeFromPath((String)path);
                    builder.add((Object)this.makeLease(path));
                    InterProcessSemaphoreV2 interProcessSemaphoreV2 = this;
                    synchronized (interProcessSemaphoreV2) {
                        while (true) {
                            List children;
                            if (!(children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).forPath(this.leasesPath)).contains(nodeName)) {
                                this.log.error("Sequential path not found: " + path);
                                throw new KeeperException.NoNodeException("Sequential path not found: " + path);
                            }
                            if (children.size() <= this.maxLeases) {
                                continue block13;
                            }
                            if (hasWait) {
                                long thisWaitMs = this.getThisWaitMs(startMs, waitMs);
                                if (thisWaitMs <= 0L) {
                                    Collection<Lease> collection = null;
                                    return collection;
                                }
                                this.wait(thisWaitMs);
                                continue;
                            }
                            this.wait();
                        }
                    }
                }
                finally {
                    this.lock.release();
                }
            }
            success = true;
            return builder.build();
        }
        finally {
            if (!success) {
                this.returnAll((Collection<Lease>)builder.build());
            }
        }
    }

    private long getThisWaitMs(long startMs, long waitMs) {
        long elapsedMs = System.currentTimeMillis() - startMs;
        return waitMs - elapsedMs;
    }

    private Lease makeLease(final String path) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    InterProcessSemaphoreV2.this.client.delete().guaranteed().forPath(path);
                }
                catch (KeeperException.NoNodeException e) {
                    InterProcessSemaphoreV2.this.log.warn("Lease already released", (Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public byte[] getData() throws Exception {
                return (byte[])InterProcessSemaphoreV2.this.client.getData().forPath(path);
            }
        };
    }

    private synchronized void notifyFromWatcher() {
        this.notifyAll();
    }
}

