/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.nodes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CreateModable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentNode
implements Closeable {
    private final AtomicReference<CountDownLatch> initialCreateLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final CreateModable<ACLBackgroundPathAndBytesable<String>> createMethod;
    private final AtomicReference<String> nodePath = new AtomicReference<Object>(null);
    private final String basePath;
    private final CreateMode mode;
    private final AtomicReference<byte[]> data = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean authFailure = new AtomicBoolean(false);
    private final BackgroundCallback backgroundCallback;
    private final boolean useProtection;
    private final CuratorWatcher watcher = new CuratorWatcher(){

        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                PersistentNode.this.createNode();
            } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                PersistentNode.this.watchNode();
            }
        }
    };
    private final BackgroundCallback checkExistsCallback = new BackgroundCallback(){

        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                PersistentNode.this.createNode();
            } else {
                boolean isEphemeral;
                boolean bl = isEphemeral = event.getStat().getEphemeralOwner() != 0L;
                if (isEphemeral != PersistentNode.this.mode.isEphemeral()) {
                    PersistentNode.this.log.warn("Existing node ephemeral state doesn't match requested state. Maybe the node was created outside of PersistentNode? " + PersistentNode.this.basePath);
                }
            }
        }
    };
    private final BackgroundCallback setDataCallback = new BackgroundCallback(){

        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                PersistentNode.this.initialisationComplete();
            }
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED) {
                PersistentNode.this.createNode();
            }
        }
    };

    public PersistentNode(CuratorFramework client, CreateMode mode, boolean useProtection, String basePath, byte[] initData) {
        this.useProtection = useProtection;
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.basePath = PathUtils.validatePath((String)basePath);
        this.mode = (CreateMode)Preconditions.checkNotNull((Object)mode, (Object)"mode cannot be null");
        byte[] data = (byte[])Preconditions.checkNotNull((Object)initData, (Object)"data cannot be null");
        this.backgroundCallback = new BackgroundCallback(){

            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                if (PersistentNode.this.state.get() == State.STARTED) {
                    PersistentNode.this.processBackgroundCallback(event);
                } else {
                    PersistentNode.this.processBackgroundCallbackClosedState(event);
                }
            }
        };
        this.createMethod = (CreateModable)(useProtection ? client.create().creatingParentContainersIfNeeded().withProtection() : client.create().creatingParentContainersIfNeeded());
        this.data.set(Arrays.copyOf(data, data.length));
    }

    private void processBackgroundCallbackClosedState(CuratorEvent event) {
        String path = null;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        }
        if (path != null) {
            try {
                ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(path);
            }
            catch (Exception e) {
                this.log.error("Could not delete node after close", (Throwable)e);
            }
        }
    }

    private void processBackgroundCallback(CuratorEvent event) throws Exception {
        String path = null;
        boolean nodeExists = false;
        if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
            path = event.getPath();
            nodeExists = true;
        } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
            path = event.getName();
        } else if (event.getResultCode() == KeeperException.Code.NOAUTH.intValue()) {
            this.log.warn("Client does not have authorisation to write node at path {}", (Object)event.getPath());
            this.authFailure.set(true);
            return;
        }
        if (path != null) {
            this.authFailure.set(false);
            this.nodePath.set(path);
            this.watchNode();
            if (nodeExists) {
                ((PathAndBytesable)this.client.setData().inBackground(this.setDataCallback)).forPath(this.getActualPath(), this.getData());
            } else {
                this.initialisationComplete();
            }
        } else {
            this.createNode();
        }
    }

    private void initialisationComplete() {
        CountDownLatch localLatch = this.initialCreateLatch.getAndSet(null);
        if (localLatch != null) {
            localLatch.countDown();
        }
    }

    public void start() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Already started");
        this.client.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.createNode();
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"Not started");
        CountDownLatch localLatch = this.initialCreateLatch.get();
        return localLatch == null || localLatch.await(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        if (!this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            return;
        }
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new IOException(e);
        }
    }

    public String getActualPath() {
        return this.nodePath.get();
    }

    public void setData(byte[] data) throws Exception {
        data = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        this.data.set(Arrays.copyOf(data, data.length));
        if (this.isActive()) {
            ((PathAndBytesable)this.client.setData().inBackground()).forPath(this.getActualPath(), this.getData());
        }
    }

    public byte[] getData() {
        return this.data.get();
    }

    private void deleteNode() throws Exception {
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath != null) {
            try {
                this.client.delete().guaranteed().forPath(localNodePath);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    private void createNode() {
        if (!this.isActive()) {
            return;
        }
        try {
            String existingPath = this.nodePath.get();
            String createPath = existingPath != null && !this.useProtection ? existingPath : this.basePath;
            ((PathAndBytesable)((ACLBackgroundPathAndBytesable)this.createMethod.withMode(this.getCreateMode(existingPath != null))).inBackground(this.backgroundCallback)).forPath(createPath, this.data.get());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new RuntimeException("Creating node. BasePath: " + this.basePath, e);
        }
    }

    private CreateMode getCreateMode(boolean pathIsSet) {
        if (pathIsSet) {
            switch (this.mode) {
                default: {
                    break;
                }
                case EPHEMERAL_SEQUENTIAL: {
                    return CreateMode.EPHEMERAL;
                }
                case PERSISTENT_SEQUENTIAL: {
                    return CreateMode.PERSISTENT;
                }
            }
        }
        return this.mode;
    }

    private void watchNode() throws Exception {
        if (!this.isActive()) {
            return;
        }
        String localNodePath = this.nodePath.get();
        if (localNodePath != null) {
            ((Pathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.checkExistsCallback)).forPath(localNodePath);
        }
    }

    private boolean isActive() {
        return this.state.get() == State.STARTED;
    }

    @VisibleForTesting
    boolean isAuthFailure() {
        return this.authFailure.get();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

