/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
public class PrimitiveTextProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static boolean isSupported(Class<?> type, MediaType mt) {
        boolean isPrimitive = InjectionUtils.isPrimitiveOnly(type) || Enum.class.isAssignableFrom(type);
        return isPrimitive && mt.isCompatible(MediaType.TEXT_PLAIN_TYPE);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return PrimitiveTextProvider.isSupported(type, mt);
    }

    public T readFrom(Class<T> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        String string = IOUtils.toString((InputStream)is, (String)HttpUtils.getEncoding(mt, StandardCharsets.UTF_8.name()));
        if (StringUtils.isEmpty((String)string)) {
            this.reportEmptyContentLength();
        }
        if (type == Character.class) {
            char character = string.charAt(0);
            return type.cast(Character.valueOf(character));
        }
        return InjectionUtils.handleParameter(string, false, type, genType, anns, ParameterType.REQUEST_BODY, null);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return PrimitiveTextProvider.isSupported(type, mt);
    }

    public void writeTo(T obj, Class<?> type, Type genType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        String encoding = HttpUtils.getSetEncoding(mt, headers, StandardCharsets.UTF_8.name());
        byte[] bytes = obj.toString().getBytes(encoding);
        os.write(bytes);
    }
}

