/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsProxyFactoryBean
extends ClientProxyFactoryBean {
    List<Handler> handlers = new ArrayList<Handler>();
    boolean loadHandlers = true;

    public JaxWsProxyFactoryBean() {
        super((ClientFactoryBean)new JaxWsClientFactoryBean());
    }

    public void setHandlers(List<Handler> h) {
        this.handlers.clear();
        this.handlers.addAll(h);
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setLoadHandlers(boolean b) {
        this.loadHandlers = b;
    }

    public boolean isLoadHandlers() {
        return this.loadHandlers;
    }

    protected ClientProxy clientClientProxy(Client c) {
        JaxWsClientProxy cp = new JaxWsClientProxy(c, ((JaxWsEndpointImpl)c.getEndpoint()).getJaxwsBinding());
        cp.getRequestContext().putAll(this.getProperties());
        this.buildHandlerChain(cp);
        return cp;
    }

    protected Class[] getImplementingClasses() {
        Class cls = this.getClientFactoryBean().getServiceClass();
        return new Class[]{cls, BindingProvider.class};
    }

    public Object create() {
        Object obj = super.create();
        Service service = this.getServiceFactory().getService();
        if (this.needWrapperClassInterceptor((ServiceInfo)service.getServiceInfos().get(0))) {
            List in = super.getInInterceptors();
            List out = super.getOutInterceptors();
            in.add(new WrapperClassInInterceptor());
            in.add(new HolderInInterceptor());
            out.add(new WrapperClassOutInterceptor());
            out.add(new HolderOutInterceptor());
        }
        return obj;
    }

    private boolean needWrapperClassInterceptor(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return false;
        }
        for (OperationInfo opInfo : serviceInfo.getInterface().getOperations()) {
            if (!opInfo.isUnwrappedCapable() || opInfo.getProperty("wrapper.gen.needed") == null) continue;
            return true;
        }
        return false;
    }

    private void buildHandlerChain(JaxWsClientProxy cp) {
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
        if (this.loadHandlers) {
            chain.addAll(builder.buildHandlerChainFromClass(sf.getServiceClass(), sf.getEndpointInfo().getName(), sf.getServiceQName(), this.getBindingId()));
        }
        if (!chain.isEmpty()) {
            ResourceManager resourceManager = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
            List resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
            ResourceInjector injector = new ResourceInjector(resourceManager);
            for (Handler h : chain) {
                if (Proxy.isProxyClass(h.getClass()) && this.getServiceClass() != null) {
                    injector.inject((Object)h, this.getServiceClass());
                    injector.construct((Object)h, this.getServiceClass());
                    continue;
                }
                injector.inject((Object)h);
                injector.construct((Object)h);
            }
        }
        cp.getBinding().setHandlerChain(chain);
    }
}

