/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.transform.IgnoreNamespacesWriter;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.codehaus.jettison.mapped.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONUtils {
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Charset UTF8 = Charset.forName("utf-8");

    private JSONUtils() {
    }

    public static XMLStreamWriter createBadgerFishWriter(OutputStream os) throws XMLStreamException {
        BadgerFishXMLOutputFactory factory = new BadgerFishXMLOutputFactory();
        return factory.createXMLStreamWriter(os);
    }

    public static XMLStreamReader createBadgerFishReader(InputStream is) throws XMLStreamException {
        BadgerFishXMLInputFactory factory = new BadgerFishXMLInputFactory();
        return factory.createXMLStreamReader(is);
    }

    public static XMLStreamWriter createStreamWriter(OutputStream os, QName qname, boolean writeXsiType, Configuration config, boolean serializeAsArray, List<String> arrayKeys, boolean dropRootElement) throws Exception {
        MappedNamespaceConvention convention = new MappedNamespaceConvention(config);
        MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, UTF8));
        if (serializeAsArray) {
            if (arrayKeys != null) {
                for (String key : arrayKeys) {
                    xsw.serializeAsArray(key);
                }
            } else {
                String key = JSONUtils.getKey(convention, qname);
                xsw.serializeAsArray(key);
            }
        }
        IgnoreContentJettisonWriter writer = !writeXsiType || dropRootElement ? new IgnoreContentJettisonWriter((XMLStreamWriter)xsw, writeXsiType, dropRootElement ? qname : null) : xsw;
        return writer;
    }

    public static Configuration createConfiguration(ConcurrentHashMap<String, String> namespaceMap, boolean writeXsiType, boolean attributesAsElements, TypeConverter converter) {
        if (writeXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        Configuration c = new Configuration(namespaceMap);
        c.setSupressAtAttributes(attributesAsElements);
        if (converter != null) {
            c.setTypeConverter(converter);
        }
        return c;
    }

    public static XMLStreamWriter createIgnoreMixedContentWriterIfNeeded(XMLStreamWriter writer, boolean ignoreMixedContent) {
        return ignoreMixedContent ? new IgnoreMixedContentWriter(writer) : writer;
    }

    public static XMLStreamWriter createIgnoreNsWriterIfNeeded(XMLStreamWriter writer, boolean ignoreNamespaces) {
        return ignoreNamespaces ? new IgnoreNamespacesWriter(writer) : writer;
    }

    private static String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap) throws Exception {
        return JSONUtils.createStreamReader(is, readXsiType, namespaceMap, null);
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap, DocumentDepthProperties depthProps) throws Exception {
        if (readXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        JettisonMappedReaderFactory factory = depthProps != null ? new JettisonMappedReaderFactory(namespaceMap, depthProps) : new MappedXMLInputFactory(namespaceMap);
        return new JettisonReader(namespaceMap, ((XMLInputFactory)((Object)factory)).createXMLStreamReader(is));
    }

    private static class IgnoreMixedContentWriter
    extends DelegatingXMLStreamWriter {
        String lastText;
        boolean isMixed;
        List<Boolean> mixed = new LinkedList<Boolean>();

        public IgnoreMixedContentWriter(XMLStreamWriter writer) {
            super(writer);
        }

        public void writeCharacters(String text) throws XMLStreamException {
            if (StringUtils.isEmpty((String)text.trim())) {
                this.lastText = text;
            } else if (this.lastText != null) {
                this.lastText = this.lastText + text;
            } else if (!this.isMixed) {
                super.writeCharacters(text);
            } else {
                this.lastText = text;
            }
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String uri, String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(uri, local);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(local);
        }

        public void writeEndElement() throws XMLStreamException {
            if (!(this.lastText == null || this.isMixed && StringUtils.isEmpty((String)this.lastText.trim()))) {
                super.writeCharacters(this.lastText.trim());
            }
            super.writeEndElement();
            this.isMixed = this.mixed.get(0);
            this.mixed.remove(0);
        }
    }

    private static class IgnoreContentJettisonWriter
    extends DelegatingXMLStreamWriter {
        private boolean writeXsiType;
        private QName ignoredQName;
        private boolean rootDropped;
        private int index;

        public IgnoreContentJettisonWriter(XMLStreamWriter writer, boolean writeXsiType, QName qname) {
            super(writer);
            this.writeXsiType = writeXsiType;
            this.ignoredQName = qname;
        }

        public void writeAttribute(String prefix, String uri, String local, String value) throws XMLStreamException {
            if (!this.writeXsiType && JSONUtils.XSI_PREFIX.equals(prefix) && ("type".equals(local) || "nil".equals(local))) {
                return;
            }
            super.writeAttribute(prefix, uri, local, value);
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            ++this.index;
            if (this.ignoredQName != null && this.ignoredQName.getLocalPart().equals(local) && this.ignoredQName.getNamespaceURI().equals(uri)) {
                this.rootDropped = true;
                return;
            }
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            this.writeStartElement("", local, "");
        }

        public void writeEndElement() throws XMLStreamException {
            --this.index;
            if (this.rootDropped && this.index == 0) {
                return;
            }
            super.writeEndElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettisonReader
    extends DepthXMLStreamReader {
        private Map<String, String> namespaceMap;

        public JettisonReader(Map<String, String> nsMap, XMLStreamReader reader) {
            super(reader);
            this.namespaceMap = nsMap;
        }

        public String getAttributePrefix(int n) {
            QName name = this.getAttributeName(n);
            if (name != null && JSONUtils.XSI_URI.equals(name.getNamespaceURI())) {
                return JSONUtils.XSI_PREFIX;
            }
            return super.getAttributePrefix(n);
        }

        public NamespaceContext getNamespaceContext() {
            return new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    for (Map.Entry entry : JettisonReader.this.namespaceMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(prefix)) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                @Override
                public String getPrefix(String ns) {
                    return (String)JettisonReader.this.namespaceMap.get(ns);
                }

                public Iterator<?> getPrefixes(String ns) {
                    String prefix = this.getPrefix(ns);
                    return prefix == null ? null : Collections.singletonList(prefix).iterator();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettisonMappedReaderFactory
    extends MappedXMLInputFactory {
        private DocumentDepthProperties depthProps;

        public JettisonMappedReaderFactory(Map<?, ?> nstojns, DocumentDepthProperties depthProps) {
            super(nstojns);
            this.depthProps = depthProps;
        }

        protected JSONTokener createNewJSONTokener(String doc) {
            return new JSONTokener(doc, this.depthProps.getInnerElementCountThreshold());
        }
    }
}

