/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.provider.jsonp.AbstractJsonpOutInterceptor;
import org.apache.cxf.message.Message;

public class JsonpPreStreamInterceptor
extends AbstractJsonpOutInterceptor {
    private String mediaType = "application/x-javascript";
    private String paddingEnd = "(";

    public JsonpPreStreamInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        String callback = this.getCallbackValue(message);
        if (!StringUtils.isEmpty((String)callback)) {
            this.setContentType(message);
            this.writeValue(message, callback + this.getPaddingEnd());
        }
    }

    protected void setContentType(Message message) {
        HashMap<String, List<String>> headers = (HashMap<String, List<String>>)message.get((Object)Message.PROTOCOL_HEADERS);
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        headers.put("Content-Type", Collections.singletonList(this.getMediaType()));
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setPaddingEnd(String paddingEnd) {
        this.paddingEnd = paddingEnd;
    }

    public String getPaddingEnd() {
        return this.paddingEnd;
    }
}

