/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.tika;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.cxf.jaxrs.ext.search.DefaultParamConverterProvider;

public class LuceneDocumentMetadata {
    private final Map<String, Class<?>> fieldTypes;
    private final String contentFieldName;
    private String source;
    private ParamConverterProvider converterProvider = new DefaultParamConverterProvider();

    public LuceneDocumentMetadata() {
        this("contents");
    }

    public LuceneDocumentMetadata(String contentFieldName) {
        this(contentFieldName, new LinkedHashMap());
    }

    public LuceneDocumentMetadata(Map<String, Class<?>> fieldTypes) {
        this("contents", fieldTypes);
    }

    public LuceneDocumentMetadata(String contentFieldName, Map<String, Class<?>> fieldTypes) {
        this.contentFieldName = contentFieldName;
        this.fieldTypes = fieldTypes;
    }

    public LuceneDocumentMetadata withField(String name, Class<?> type) {
        this.fieldTypes.put(name, type);
        return this;
    }

    public LuceneDocumentMetadata withFieldTypeConverter(ParamConverterProvider provider) {
        this.converterProvider = provider;
        return this;
    }

    public LuceneDocumentMetadata withSource(String src) {
        this.source = src;
        return this;
    }

    public String getContentFieldName() {
        return this.contentFieldName;
    }

    public String getSource() {
        return this.source;
    }

    public Class<?> getFieldType(String name) {
        return this.fieldTypes.get(name);
    }

    public Map<String, Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public ParamConverterProvider getFieldTypeConverter() {
        return this.converterProvider;
    }
}

