/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweJsonEncryptionEntry;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class AbstractJweJsonDecryptingFilter {
    private JweDecryptionProvider decryption;
    private String defaultMediaType;
    private Map<String, Object> recipientProperties;

    protected JweDecryptionOutput decrypt(InputStream is) throws IOException {
        JweDecryptionProvider theProvider;
        JweJsonConsumer c = new JweJsonConsumer(new String(IOUtils.readBytesFromStream((InputStream)is), StandardCharsets.UTF_8));
        JweJsonEncryptionEntry entry = c.getJweDecryptionEntry(theProvider = this.getInitializedDecryptionProvider(c.getProtectedHeader()), this.recipientProperties);
        if (entry == null) {
            throw new JweException(JweException.Error.INVALID_JSON_JWE);
        }
        JweDecryptionOutput out = c.decryptWith(theProvider, entry);
        JAXRSUtils.getCurrentMessage().put(JweJsonConsumer.class, (Object)c);
        JAXRSUtils.getCurrentMessage().put(JweJsonEncryptionEntry.class, (Object)entry);
        return out;
    }

    protected void validateHeaders(JweHeaders headers) {
    }

    public void setDecryptionProvider(JweDecryptionProvider decryptor) {
        this.decryption = decryptor;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders headers) {
        if (this.decryption != null) {
            return this.decryption;
        }
        return JweUtils.loadDecryptionProvider((JweHeaders)headers, (boolean)true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public void setRecipientProperties(Map<String, Object> recipientProperties) {
        this.recipientProperties = recipientProperties;
    }
}

