/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsJsonReaderProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwsJsonReaderProvider.class);
    private JwsSignatureVerifier sigVerifier;
    private String defaultMediaType;
    private Map<String, Object> entryProps;

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.sigVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.sigVerifier != null) {
            return this.sigVerifier;
        }
        return JwsUtils.loadSignatureVerifier(null, (boolean)true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    protected void validate(JwsJsonConsumer c, JwsSignatureVerifier theSigVerifier) throws JwsException {
        List remaining = c.verifyAndGetNonValidated(Collections.singletonList(theSigVerifier), this.entryProps);
        if (!remaining.isEmpty()) {
            JAXRSUtils.getCurrentMessage().put((Object)"jws.json.remaining.entries", (Object)remaining);
        }
        JAXRSUtils.getCurrentMessage().put(JwsJsonConsumer.class, (Object)c);
    }

    public Map<String, Object> getEntryProps() {
        return this.entryProps;
    }

    public void setEntryProps(Map<String, Object> entryProps) {
        this.entryProps = entryProps;
    }
}

