/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.jwt;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jaxrs.JwtAuthenticationFilter;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.security.SecurityContext;

public class JwtBearerAuthHandler
extends JwtAuthenticationFilter {
    private FormEncodingProvider<Form> provider = new FormEncodingProvider(true);

    public void filter(ContainerRequestContext context) {
        String decodedAssertionType;
        Message message = JAXRSUtils.getCurrentMessage();
        Form form = this.readFormData(message);
        MultivaluedMap formData = form.asMap();
        String assertionType = (String)formData.getFirst((Object)"client_assertion_type");
        String string = decodedAssertionType = assertionType != null ? HttpUtils.urlDecode((String)assertionType) : null;
        if (decodedAssertionType == null || !"urn:ietf:params:oauth:client-assertion-type:jwt-bearer".equals(decodedAssertionType)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        String assertion = (String)formData.getFirst((Object)"client_assertion");
        JwtToken token = super.getJwtToken(assertion);
        String clientId = (String)formData.getFirst((Object)"client_id");
        String subjectName = (String)token.getClaim("sub");
        if (clientId != null && !clientId.equals(subjectName)) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        message.put((Object)"client_id", (Object)subjectName);
        formData.remove((Object)"client_id");
        formData.remove((Object)"client_assertion");
        formData.remove((Object)"client_assertion_type");
        SecurityContext securityContext = this.configureSecurityContext(token);
        if (securityContext != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)securityContext);
        }
        try {
            FormUtils.restoreForm(this.provider, (Form)form, (Message)message);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    private Form readFormData(Message message) {
        try {
            return FormUtils.readForm(this.provider, (Message)message);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    protected void validateToken(JwtToken jwt) {
        super.validateToken(jwt);
        if (jwt.getClaim("iss") == null) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (jwt.getClaim("sub") == null) {
            throw new OAuthServiceException("invalid_grant");
        }
        if (jwt.getClaim("exp") == null) {
            throw new OAuthServiceException("invalid_grant");
        }
    }
}

