/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtProducer;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class OAuthServerJoseJwtProducer
extends OAuthJoseJwtProducer {
    private boolean encryptWithClientCertificates;

    public String processJwt(JwtToken jwt, Client client) {
        return this.processJwt(jwt, this.getInitializedEncryptionProvider(client), this.getInitializedSignatureProvider(client));
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(Client c) {
        JweEncryptionProvider theEncryptionProvider = null;
        if (this.encryptWithClientCertificates && c != null && !c.getApplicationCertificates().isEmpty()) {
            X509Certificate cert = (X509Certificate)CryptoUtils.decodeCertificate((String)c.getApplicationCertificates().get(0));
            theEncryptionProvider = JweUtils.createJweEncryptionProvider((PublicKey)((RSAPublicKey)cert.getPublicKey()), (KeyAlgorithm)KeyAlgorithm.RSA_OAEP, (ContentAlgorithm)ContentAlgorithm.A128GCM, null);
        }
        if (theEncryptionProvider == null && c != null && c.getClientSecret() != null) {
            theEncryptionProvider = super.getInitializedEncryptionProvider(c.getClientSecret());
        }
        return theEncryptionProvider;
    }

    protected JwsSignatureProvider getInitializedSignatureProvider(Client c) {
        if (c == null) {
            return null;
        }
        return super.getInitializedSignatureProvider(c.getClientSecret());
    }

    public void setEncryptWithClientCertificates(boolean encryptWithClientCertificates) {
        if (this.isEncryptWithClientSecret()) {
            throw new SecurityException();
        }
        this.encryptWithClientCertificates = encryptWithClientCertificates;
    }
}

