/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.jwt;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstactJwtAccessTokenValidator
extends JoseJwtConsumer
implements AccessTokenValidator {
    private OAuthDataProvider dataProvider;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("*");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        ServerAccessToken at = this.dataProvider.getAccessToken(authSchemeData);
        super.getJwtToken(at.getTokenKey());
        return new AccessTokenValidation(at);
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }
}

