/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;

public final class SSLUtils {
    private SSLUtils() {
    }

    public static HostnameVerifier getHostnameVerifier(TLSClientParameters tlsClientParameters) {
        HostnameVerifier verifier = tlsClientParameters.getHostnameVerifier() != null ? tlsClientParameters.getHostnameVerifier() : (tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (tlsClientParameters.isDisableCNCheck() ? CertificateHostnameVerifier.ALLOW_ALL : CertificateHostnameVerifier.DEFAULT));
        return verifier;
    }

    public static SSLContext getSSLContext(TLSParameterBase parameters) throws Exception {
        SSLContext ctx;
        String provider = parameters.getJsseProvider();
        String protocol = parameters.getSecureSocketProtocol() != null ? parameters.getSecureSocketProtocol() : "TLS";
        SSLContext sSLContext = ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        if (parameters instanceof TLSClientParameters) {
            ctx.getClientSessionContext().setSessionTimeout(((TLSClientParameters)parameters).getSslCacheTimeout());
        }
        KeyManager[] keyManagers = parameters.getKeyManagers();
        if (parameters.getCertAlias() != null) {
            SSLUtils.getKeyManagersWithCertAlias(parameters, keyManagers);
        }
        ctx.init(keyManagers, parameters.getTrustManagers(), parameters.getSecureRandom());
        return ctx;
    }

    protected static void getKeyManagersWithCertAlias(TLSParameterBase tlsParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (tlsParameters.getCertAlias() != null) {
            for (int idx = 0; idx < keyManagers.length; ++idx) {
                if (!(keyManagers[idx] instanceof X509KeyManager)) continue;
                try {
                    keyManagers[idx] = new AliasedX509ExtendedKeyManager(tlsParameters.getCertAlias(), (X509KeyManager)keyManagers[idx]);
                    continue;
                }
                catch (Exception e) {
                    throw new GeneralSecurityException(e);
                }
            }
        }
    }

    public static SSLEngine createServerSSLEngine(TLSServerParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(parameters.getClientAuthentication().isRequired());
        return serverEngine;
    }

    public static SSLEngine createClientSSLEngine(TLSClientParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }
}

