/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.SequenceFault;

public class RMCaptureInInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(RMCaptureInInterceptor.class);

    public RMCaptureInInterceptor() {
        super("post-stream");
        this.addAfter(StaxInInterceptor.class.getName());
    }

    @Override
    protected void handle(Message message) throws SequenceFault, RMException {
        if (!MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.oneway.robust")) && (this.getManager().getStore() != null || this.getManager().getDestinationPolicy() != null && this.getManager().getDestinationPolicy().getRetryPolicy() != null)) {
            message.getInterceptorChain().add((Interceptor)new RMCaptureInEnd());
            XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (null != reader) {
                CachedOutputStream saved = new CachedOutputStream();
                try {
                    StaxUtils.copy((XMLStreamReader)reader, (OutputStream)saved);
                    saved.flush();
                    saved.holdTempFile();
                    reader.close();
                    LOG.fine("Create new XMLStreamReader");
                    InputStream is = saved.getInputStream();
                    this.setCloseable(message, saved, is);
                    XMLStreamReader newReader = StaxUtils.createXMLStreamReader((InputStream)is);
                    StaxUtils.configureReader((XMLStreamReader)reader, (Message)message);
                    message.setContent(XMLStreamReader.class, (Object)newReader);
                    LOG.fine("Capturing the original RM message");
                    message.put((Object)"org.apache.cxf.ws.rm.content", (Object)saved);
                }
                catch (IOException | XMLStreamException e) {
                    throw new Fault((Throwable)e);
                }
            } else {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("No message found for redeliver", LOG, new Object[]{Collections.emptyList()});
                RMException ex = new RMException(msg);
                throw new Fault((Throwable)((Object)ex));
            }
        }
    }

    private boolean isApplicationMessage(Message message) {
        AddressingProperties maps = RMContextUtils.retrieveMAPs(message, false, false);
        if (null != maps && null != maps.getAction()) {
            return !RMContextUtils.isRMProtocolMessage(maps.getAction().getValue());
        }
        return false;
    }

    private void setCloseable(Message message, final CachedOutputStream cos, final InputStream is) {
        message.put((Object)"org.apache.cxf.ws.rm.content.closeable", (Object)new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    cos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private class RMCaptureInEnd
    extends AbstractPhaseInterceptor<Message> {
        RMCaptureInEnd() {
            super("pre-logical");
            this.addBefore(RMInInterceptor.class.getName());
        }

        public void handleFault(Message message) {
            Exception ex = (Exception)message.getContent(Exception.class);
            if (ex instanceof SequenceFault) {
                CachedOutputStream saved;
                Closeable closable = (Closeable)message.get((Object)"org.apache.cxf.ws.rm.content.closeable");
                if (null != closable) {
                    try {
                        closable.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if ((saved = (CachedOutputStream)message.get((Object)"org.apache.cxf.ws.rm.content")) != null) {
                    saved.releaseTempFileHold();
                    try {
                        saved.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }

        public void handleMessage(Message message) {
            LOG.entering(((Object)((Object)this)).getClass().getName(), "handleMessage");
            if (!MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.oneway.robust")) && RMCaptureInInterceptor.this.isApplicationMessage(message) && (RMCaptureInInterceptor.this.getManager().getStore() != null || RMCaptureInInterceptor.this.getManager().getDestinationPolicy() != null && RMCaptureInInterceptor.this.getManager().getDestinationPolicy().getRetryPolicy() != null)) {
                CachedOutputStream saved = new CachedOutputStream();
                SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                if (soapMessage != null) {
                    try {
                        Source envelope = soapMessage.getSOAPPart().getContent();
                        StaxUtils.copy((Source)envelope, (OutputStream)saved);
                        saved.flush();
                        InputStream is = saved.getInputStream();
                        this.closeOldSavedContent(message);
                        RMCaptureInInterceptor.this.setCloseable(message, saved, is);
                        StreamSource source = new StreamSource(is);
                        soapMessage.getSOAPPart().setContent((Source)source);
                        message.put((Object)"org.apache.cxf.ws.rm.content", (Object)this.removeUnnecessarySoapHeaders(saved));
                    }
                    catch (IOException | SOAPException | XMLStreamException e) {
                        throw new Fault(e);
                    }
                }
            }
        }

        private void closeOldSavedContent(Message message) {
            Closeable closable;
            CachedOutputStream saved = (CachedOutputStream)message.get((Object)"org.apache.cxf.ws.rm.content");
            if (saved != null) {
                saved.releaseTempFileHold();
                try {
                    saved.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (null != (closable = (Closeable)message.get((Object)"org.apache.cxf.ws.rm.content.closeable"))) {
                try {
                    closable.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        private CachedOutputStream removeUnnecessarySoapHeaders(CachedOutputStream saved) {
            CachedOutputStream newSaved = new CachedOutputStream();
            InputStream is = null;
            try {
                is = saved.getInputStream();
                XMLStreamWriter capture = StaxUtils.createXMLStreamWriter((OutputStream)newSaved, (String)StandardCharsets.UTF_8.name());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("{http://schemas.xmlsoap.org/ws/2005/02/rm}Sequence", "");
                map.put("{http://schemas.xmlsoap.org/ws/2005/02/rm}SequenceAcknowledgement", "");
                map.put("{http://docs.oasis-open.org/ws-rx/wsrm/200702}Sequence", "");
                map.put("{http://docs.oasis-open.org/ws-rx/wsrm/200702}SequenceAcknowledgement", "");
                map.put("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}Security", "");
                HashMap<String, String> amap = new HashMap<String, String>();
                amap.put("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Id", "");
                capture = new OutTransformWriter(capture, map, Collections.emptyMap(), Collections.emptyList(), amap, false, null);
                StaxUtils.copy((Source)new StreamSource(is), (XMLStreamWriter)capture);
                capture.flush();
                capture.close();
                newSaved.flush();
                newSaved.holdTempFile();
                is.close();
            }
            catch (IOException | XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
            finally {
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            return newSaved;
        }
    }
}

