/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.BindingPolicyValidator;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.PKIPathSecurity;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.EncryptionToken;
import org.apache.wss4j.policy.model.ProtectionToken;
import org.apache.wss4j.policy.model.SignatureToken;
import org.apache.wss4j.policy.model.X509Token;
import org.w3c.dom.Element;

public abstract class AbstractBindingPolicyValidator
implements BindingPolicyValidator {
    private static final QName SIG_QNAME = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");

    protected boolean validateTimestamp(boolean includeTimestamp, boolean transportBinding, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, Message message) {
        List timestampResults = WSSecurityUtil.fetchAllActionResults(results, (int)32);
        if (includeTimestamp && timestampResults.size() != 1) {
            return false;
        }
        if (!includeTimestamp) {
            return timestampResults.isEmpty();
        }
        if (transportBinding) {
            return true;
        }
        if (!signedResults.isEmpty()) {
            Timestamp timestamp = (Timestamp)((WSSecurityEngineResult)timestampResults.get(0)).get((Object)"timestamp");
            for (WSSecurityEngineResult signedResult : signedResults) {
                List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
                for (WSDataRef dataRef : dataRefs) {
                    if (timestamp.getElement() != dataRef.getProtectedElement()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean validateEntireHeaderAndBodySignatures(List<WSSecurityEngineResult> signedResults) {
        for (WSSecurityEngineResult signedResult : signedResults) {
            List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (dataRefs == null) continue;
            for (WSDataRef dataRef : dataRefs) {
                String xpath = dataRef.getXpath();
                if (xpath == null) continue;
                String[] nodes = StringUtils.split((String)xpath, (String)"/");
                if (nodes.length < 3 || nodes.length > 5) {
                    return false;
                }
                if (!nodes[2].contains("Header") && !nodes[2].contains("Body")) {
                    return false;
                }
                if (nodes.length == 5 && !nodes[3].contains("Security")) {
                    return false;
                }
                if (nodes.length != 4 || !nodes[2].contains("Body")) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkProperties(AbstractSymmetricAsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, Message message) {
        if (!this.validateTimestamp(binding.isIncludeTimestamp(), false, results, signedResults, message)) {
            String error = "Received Timestamp does not match the requirements";
            ai.setNotAsserted(error);
            return false;
        }
        this.assertPolicy(aim, "IncludeTimestamp");
        if (binding.isOnlySignEntireHeadersAndBody() && !this.validateEntireHeaderAndBodySignatures(signedResults)) {
            String error = "OnlySignEntireHeadersAndBody does not match the requirements";
            ai.setNotAsserted(error);
            return false;
        }
        this.assertPolicy(aim, "OnlySignEntireHeadersAndBody");
        if (binding.isEncryptSignature() && !this.isSignatureEncrypted(results)) {
            ai.setNotAsserted("The signature is not protected");
            return false;
        }
        this.assertPolicy(aim, "EncryptSignature");
        this.assertPolicy(aim, "ProtectTokens");
        return true;
    }

    protected boolean checkProtectionOrder(AbstractSymmetricAsymmetricBinding binding, AssertionInfoMap aim, AssertionInfo ai, List<WSSecurityEngineResult> results) {
        AbstractSymmetricAsymmetricBinding.ProtectionOrder protectionOrder = binding.getProtectionOrder();
        if (protectionOrder == AbstractSymmetricAsymmetricBinding.ProtectionOrder.EncryptBeforeSigning) {
            if (!binding.isProtectTokens() && this.isSignedBeforeEncrypted(results)) {
                ai.setNotAsserted("Not encrypted before signed");
                return false;
            }
            this.assertPolicy(aim, "EncryptBeforeSigning");
        } else if (protectionOrder == AbstractSymmetricAsymmetricBinding.ProtectionOrder.SignBeforeEncrypting) {
            if (this.isEncryptedBeforeSigned(results)) {
                ai.setNotAsserted("Not signed before encrypted");
                return false;
            }
            this.assertPolicy(aim, "SignBeforeEncrypting");
        }
        return true;
    }

    private boolean isSignedBeforeEncrypted(List<WSSecurityEngineResult> results) {
        boolean signed = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            List el = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
            if (!(actInt != 2 || el == null || el.size() == 1 && ((WSDataRef)el.get(0)).getName().equals(SIG_QNAME))) {
                signed = true;
            }
            if (actInt != 4 || el == null) continue;
            return signed;
        }
        return false;
    }

    private boolean isEncryptedBeforeSigned(List<WSSecurityEngineResult> results) {
        boolean encrypted = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            List el = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
            if (actInt == 4 && el != null) {
                encrypted = true;
            }
            if (actInt != 2 || el == null || el.size() == 1 && ((WSDataRef)el.get(0)).getName().equals(SIG_QNAME)) continue;
            return encrypted;
        }
        return false;
    }

    protected boolean checkDerivedKeys(AbstractTokenWrapper tokenWrapper, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean isDerivedKeys;
        AbstractToken token = tokenWrapper.getToken();
        boolean bl = isDerivedKeys = token.getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys;
        if (!(token instanceof X509Token) || !isDerivedKeys) {
            return true;
        }
        if (tokenWrapper instanceof EncryptionToken && !hasDerivedKeys && !encryptedResults.isEmpty()) {
            return false;
        }
        if (tokenWrapper instanceof SignatureToken && !hasDerivedKeys && !signedResults.isEmpty()) {
            return false;
        }
        return !(tokenWrapper instanceof ProtectionToken) || hasDerivedKeys || signedResults.isEmpty() || encryptedResults.isEmpty();
    }

    protected boolean isTokenProtected(List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        for (int i = 0; i < signedResults.size(); ++i) {
            WSSecurityEngineResult result = signedResults.get(i);
            WSSecurityEngineResult tokenResult = this.findCorrespondingToken(result, results);
            if (tokenResult == null) {
                return false;
            }
            List sl = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
            boolean found = false;
            if (sl != null) {
                for (WSDataRef dataRef : sl) {
                    Element referenceElement = dataRef.getProtectedElement();
                    if (referenceElement == null || !referenceElement.equals(tokenResult.get((Object)"token-element"))) continue;
                    found = true;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private WSSecurityEngineResult findCorrespondingToken(WSSecurityEngineResult signatureResult, List<WSSecurityEngineResult> results) {
        X509Certificate cert = (X509Certificate)signatureResult.get((Object)"x509-certificate");
        PublicKey publicKey = (PublicKey)signatureResult.get((Object)"public-key");
        for (WSSecurityEngineResult token : results) {
            Integer actInt = (Integer)token.get((Object)"action");
            if (actInt == 2) continue;
            BinarySecurity binarySecurity = (BinarySecurity)token.get((Object)"binary-security-token");
            PublicKey foundPublicKey = (PublicKey)token.get((Object)"public-key");
            if (binarySecurity instanceof X509Security || binarySecurity instanceof PKIPathSecurity) {
                X509Certificate foundCert = (X509Certificate)token.get((Object)"x509-certificate");
                if (!foundCert.equals(cert)) continue;
                return token;
            }
            if (actInt == 16 || actInt == 8) {
                SamlAssertionWrapper assertionWrapper = (SamlAssertionWrapper)token.get((Object)"saml-assertion");
                SAMLKeyInfo samlKeyInfo = assertionWrapper.getSubjectKeyInfo();
                if (samlKeyInfo == null) continue;
                X509Certificate[] subjectCerts = samlKeyInfo.getCerts();
                PublicKey subjectPublicKey = samlKeyInfo.getPublicKey();
                if ((cert == null || subjectCerts == null || !cert.equals(subjectCerts[0])) && (subjectPublicKey == null || !subjectPublicKey.equals(publicKey))) continue;
                return token;
            }
            if (publicKey == null || !publicKey.equals(foundPublicKey)) continue;
            return token;
        }
        return null;
    }

    protected boolean isSignatureEncrypted(List<WSSecurityEngineResult> results) {
        boolean foundPrimarySignature = false;
        for (int i = results.size() - 1; i >= 0; --i) {
            String sigId;
            WSSecurityEngineResult result = results.get(i);
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt == 2 && !foundPrimarySignature) {
                foundPrimarySignature = true;
                sigId = (String)result.get((Object)"id");
                if (sigId != null && this.isIdEncrypted(sigId, results)) continue;
                return false;
            }
            if (actInt != 128 || (sigId = (String)result.get((Object)"id")) != null && this.isIdEncrypted(sigId, results)) continue;
            return false;
        }
        return true;
    }

    private boolean isIdEncrypted(String sigId, List<WSSecurityEngineResult> results) {
        for (WSSecurityEngineResult wser : results) {
            List el;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4 || (el = CastUtils.cast((List)((List)wser.get((Object)"data-ref-uris")))) == null) continue;
            for (WSDataRef r : el) {
                Element protectedElement = r.getProtectedElement();
                if (protectedElement == null) continue;
                String id = protectedElement.getAttributeNS(null, "Id");
                String wsuId = protectedElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (!sigId.equals(id) && !sigId.equals(wsuId)) continue;
                return true;
            }
        }
        return false;
    }

    protected void assertPolicy(AssertionInfoMap aim, Assertion token) {
        Collection ais = (Collection)aim.get((Object)token.getName());
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != token) continue;
                ai.setAsserted(true);
            }
        }
    }

    protected void notAssertPolicy(AssertionInfoMap aim, Assertion token, String msg) {
        Collection ais = (Collection)aim.get((Object)token.getName());
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                if (ai.getAssertion() != token) continue;
                ai.setNotAsserted(msg);
            }
        }
    }

    protected boolean assertPolicy(AssertionInfoMap aim, String localname) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, localname);
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    protected boolean assertPolicy(AssertionInfoMap aim, QName q) {
        Collection ais = (Collection)aim.get((Object)q);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    protected void notAssertPolicy(AssertionInfoMap aim, QName q, String msg) {
        Collection ais = (Collection)aim.get((Object)q);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setNotAsserted(msg);
            }
        }
    }

    protected Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }
}

