/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

class NullEncryption
extends EncryptionEngine {
    NullEncryption() {
    }

    public EncryptionType getEncryptionType() {
        return EncryptionType.NULL;
    }

    public int getChecksumLength() {
        return 0;
    }

    public int getConfounderLength() {
        return 0;
    }

    public byte[] getDecryptedData(EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        return data.getCipher();
    }

    public EncryptedData getEncryptedData(EncryptionKey key, byte[] plainText, KeyUsage usage) {
        return new EncryptedData(this.getEncryptionType(), key.getKeyVersion(), plainText);
    }

    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return plainText;
    }

    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return cipherText;
    }

    public byte[] calculateIntegrity(byte[] plainText, byte[] key, KeyUsage usage) {
        return null;
    }
}

