/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchEngine
implements SearchEngine<ServerEntry> {
    private final Optimizer optimizer;
    private final Store<ServerEntry> db;
    private final CursorBuilder cursorBuilder;
    private final EvaluatorBuilder evaluatorBuilder;

    public DefaultSearchEngine(Store<ServerEntry> db, CursorBuilder cursorBuilder, EvaluatorBuilder evaluatorBuilder, Optimizer optimizer) {
        this.db = db;
        this.optimizer = optimizer;
        this.cursorBuilder = cursorBuilder;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public IndexCursor<Long, ServerEntry> cursor(LdapDN base, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchCtls) throws Exception {
        Long baseId = this.db.getEntryId(base.toString());
        if (baseId == null) {
            return new EmptyIndexCursor();
        }
        String aliasedBase = (String)this.db.getAliasIndex().reverseLookup(baseId);
        LdapDN effectiveBase = null == aliasedBase || !aliasDerefMode.isDerefFindingBase() ? base : new LdapDN(aliasedBase);
        if (searchCtls.getSearchScope() == 0) {
            Long effectiveBaseId = baseId;
            if (effectiveBase != base) {
                effectiveBaseId = this.db.getEntryId(effectiveBase.toNormName());
            }
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setId(effectiveBaseId);
            this.optimizer.annotate(filter);
            Evaluator<? extends ExprNode, ServerEntry> evaluator = this.evaluatorBuilder.build(filter);
            if (evaluator.evaluate((IndexEntry)indexEntry)) {
                return new SingletonIndexCursor((IndexEntry)indexEntry);
            }
            return new EmptyIndexCursor();
        }
        AndNode root = new AndNode();
        ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase.toString(), SearchScope.getSearchScope((SearchControls)searchCtls));
        root.getChildren().add(node);
        root.getChildren().add(filter);
        this.optimizer.annotate((ExprNode)root);
        return this.cursorBuilder.build((ExprNode)root);
    }

    public Evaluator<? extends ExprNode, ServerEntry> evaluator(ExprNode filter) throws Exception {
        return this.evaluatorBuilder.build(filter);
    }
}

