/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotCursor<V>
extends AbstractIndexCursor<V, ServerEntry> {
    private static final String UNSUPPORTED_MSG = "NotCursors are not ordered and do not support positioning by element.";
    private final IndexCursor<V, ServerEntry> ndnCursor;
    private final Evaluator<? extends ExprNode, ServerEntry> childEvaluator;
    private boolean available = false;

    public NotCursor(Store<ServerEntry> db, Evaluator<? extends ExprNode, ServerEntry> childEvaluator) throws Exception {
        this.childEvaluator = childEvaluator;
        this.ndnCursor = db.getNdnIndex().forwardCursor();
    }

    public boolean available() {
        return this.available;
    }

    public void beforeValue(Long id, V value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void before(IndexEntry<V, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void after(IndexEntry<V, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void afterValue(Long id, V value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.ndnCursor.beforeFirst();
        this.available = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.ndnCursor.afterLast();
        this.available = false;
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        while (this.ndnCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.ndnCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        while (this.ndnCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.ndnCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<V, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return (IndexEntry)this.ndnCursor.get();
        }
        throw new InvalidCursorPositionException("Cursor has not been positioned yet.");
    }

    public boolean isElementReused() {
        return this.ndnCursor.isElementReused();
    }

    public void close() throws Exception {
        super.close();
        this.ndnCursor.close();
    }
}

