/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ValueAction() {
        super("Store a value");
    }

    public void action(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        AddRequestCodec addRequest = ldapMessage.getAddRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Object value = null;
        if (tlv.getLength() == 0) {
            addRequest.addAttributeValue("");
        } else if (ldapMessageContainer.isBinary(addRequest.getCurrentAttributeType())) {
            value = tlv.getValue().getData();
            if (IS_DEBUG) {
                log.debug("Adding value {}", (Object)StringTools.dumpBytes(value));
            }
            addRequest.addAttributeValue((byte[])value);
        } else {
            value = StringTools.utf8ToString(tlv.getValue().getData());
            if (IS_DEBUG) {
                log.debug("Adding value {}" + value);
            }
            addRequest.addAttributeValue((String)value);
        }
        ldapMessageContainer.grammarEndAllowed(true);
    }
}

