/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import java.util.Collections;
import java.util.Set;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.context.annotation.DubboConfigConfiguration;
import org.apache.dubbo.spring.boot.autoconfigure.DubboConfigurationProperties;
import org.apache.dubbo.spring.boot.autoconfigure.DubboRelaxedBindingAutoConfiguration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@Configuration
@AutoConfigureAfter(value={DubboRelaxedBindingAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboConfigurationProperties.class})
public class DubboAutoConfiguration {
    @ConditionalOnProperty(prefix="dubbo.scan.", name={"base-packages"})
    @ConditionalOnBean(name={"dubboScanBasePackagesPropertyResolver"})
    @Bean
    public ServiceAnnotationBeanPostProcessor serviceAnnotationBeanPostProcessor(@Qualifier(value="dubboScanBasePackagesPropertyResolver") PropertyResolver propertyResolver) {
        Set packagesToScan = (Set)propertyResolver.getProperty("base-packages", Set.class, Collections.emptySet());
        return new ServiceAnnotationBeanPostProcessor(packagesToScan);
    }

    @ConditionalOnMissingBean
    @Bean(name={"referenceAnnotationBeanPostProcessor"})
    public ReferenceAnnotationBeanPostProcessor referenceAnnotationBeanPostProcessor() {
        return new ReferenceAnnotationBeanPostProcessor();
    }

    @ConditionalOnProperty(prefix="dubbo.config.", name={"multiple"}, matchIfMissing=true)
    @Import(value={DubboConfigConfiguration.Multiple.class})
    protected static class MultipleDubboConfigConfiguration {
        protected MultipleDubboConfigConfiguration() {
        }
    }

    @Import(value={DubboConfigConfiguration.Single.class})
    protected static class SingleDubboConfigConfiguration {
        protected SingleDubboConfigConfiguration() {
        }
    }
}

