/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyPersistFiles
extends LazyPersistTestCase {
    private static final byte LAZY_PERSIST_POLICY_ID = 15;
    private static final int THREADPOOL_SIZE = 10;

    @Test
    public void testPolicyNotSetByDefault() throws IOException {
        this.startUpCluster(false, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, false);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)IsNot.not((Object)15));
    }

    @Test
    public void testPolicyPropagation() throws IOException {
        this.startUpCluster(false, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }

    @Test
    public void testPolicyPersistenceInEditLog() throws IOException {
        this.startUpCluster(false, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        this.cluster.restartNameNode(true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }

    @Test
    public void testPolicyPersistenceInFsImage() throws IOException {
        this.startUpCluster(false, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNode(true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }

    @Test
    public void testPlacementOnRamDisk() throws IOException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
    }

    @Test
    public void testPlacementOnSizeLimitedRamDisk() throws IOException {
        this.startUpCluster(true, 3);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.makeTestFile(path2, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.ensureFileReplicasOnStorageType(path2, StorageType.RAM_DISK);
    }

    @Test
    public void testFallbackToDisk() throws IOException {
        this.startUpCluster(false, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.DEFAULT);
    }

    @Test
    public void testFallbackToDiskFull() throws Exception {
        this.startUpCluster(false, 0);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.DEFAULT);
        this.verifyRamDiskJMXMetric("RamDiskBlocksWriteFallback", 1L);
    }

    @Test
    public void testFallbackToDiskPartial() throws IOException, InterruptedException {
        this.startUpCluster(true, 2);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x1900000L, true);
        Thread.sleep(6000L);
        this.triggerBlockReport();
        int numBlocksOnRamDisk = 0;
        int numBlocksOnDisk = 0;
        long fileLength = this.client.getFileInfo(path.toString()).getLen();
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            if (locatedBlock.getStorageTypes()[0] == StorageType.RAM_DISK) {
                ++numBlocksOnRamDisk;
                continue;
            }
            if (locatedBlock.getStorageTypes()[0] != StorageType.DEFAULT) continue;
            ++numBlocksOnDisk;
        }
        assert (numBlocksOnRamDisk <= 2);
        assert (numBlocksOnDisk >= 3);
    }

    @Test
    public void testRamDiskNotChosenByDefault() throws IOException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        try {
            this.makeTestFile(path, 0x500000L, false);
            Assert.fail((String)"Block placement to RAM_DISK should have failed without lazyPersist flag");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
    }

    @Test
    public void testAppendIsDenied() throws IOException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        try {
            this.client.append(path.toString(), 4096, EnumSet.of(CreateFlag.APPEND), null, null).close();
            Assert.fail((String)"Append to LazyPersist file did not fail as expected");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
    }

    @Test
    public void testTruncateIsDenied() throws IOException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        try {
            this.client.truncate(path.toString(), 0x280000L);
            Assert.fail((String)"Truncate to LazyPersist file did not fail as expected");
        }
        catch (Throwable t) {
            LOG.info((Object)"Got expected exception ", t);
        }
    }

    @Test
    public void testLazyPersistFilesAreDiscarded() throws IOException, InterruptedException {
        this.startUpCluster(true, 2);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.cluster.shutdownDataNodes();
        Thread.sleep(30000L);
        Assert.assertThat((Object)this.cluster.getNamesystem().getNumDeadDataNodes(), (Matcher)Is.is((Object)1));
        Thread.sleep(6000L);
        Thread.sleep(6000L);
        assert (!this.fs.exists(path1));
        Assert.assertThat((Object)this.cluster.getNameNode().getNamesystem().getBlockManager().getUnderReplicatedBlocksCount(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void testLazyPersistBlocksAreSaved() throws IOException, InterruptedException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x3200000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        Thread.sleep(6000L);
        LOG.info((Object)"Verifying copy was saved to lazyPersist/");
        this.ensureLazyPersistBlocksAreSaved(locatedBlocks);
    }

    @Test
    public void testRamDiskEviction() throws Exception {
        this.startUpCluster(true, 2);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        Thread.sleep(3000L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.makeTestFile(path2, 0x500000L, true);
        Thread.sleep(3000L);
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path2, StorageType.RAM_DISK);
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 1L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvictedWithoutRead", 1L);
    }

    @Test
    public void testRamDiskEvictionBeforePersist() throws IOException, InterruptedException {
        this.startUpCluster(true, 1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.makeTestFile(path2, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.ensureFileReplicasOnStorageType(path2, StorageType.DEFAULT);
        assert (this.fs.exists(path1));
        assert (this.fs.exists(path2));
        Assert.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
    }

    @Test
    public void testRamDiskEvictionIsLru() throws Exception {
        int i;
        int i2;
        int NUM_PATHS = 5;
        this.startUpCluster(true, 6);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path[] paths = new Path[10];
        for (i2 = 0; i2 < paths.length; ++i2) {
            paths[i2] = new Path("/" + METHOD_NAME + "." + i2 + ".dat");
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.makeTestFile(paths[i2], 0x500000L, true);
        }
        Thread.sleep(3000L);
        for (i2 = 0; i2 < 5; ++i2) {
            this.ensureFileReplicasOnStorageType(paths[i2], StorageType.RAM_DISK);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(5);
        for (i = 0; i < 5; ++i) {
            indexes.add(i);
        }
        Collections.shuffle(indexes);
        for (i = 0; i < 5; ++i) {
            LOG.info((Object)("Touching file " + paths[(Integer)indexes.get(i)]));
            DFSTestUtil.readFile((FileSystem)this.fs, paths[(Integer)indexes.get(i)]);
        }
        for (i = 0; i < 5; ++i) {
            this.makeTestFile(paths[i + 5], 0x500000L, true);
            this.triggerBlockReport();
            Thread.sleep(3000L);
            this.ensureFileReplicasOnStorageType(paths[i + 5], StorageType.RAM_DISK);
            this.ensureFileReplicasOnStorageType(paths[(Integer)indexes.get(i)], StorageType.DEFAULT);
            for (int j = i + 1; j < 5; ++j) {
                this.ensureFileReplicasOnStorageType(paths[(Integer)indexes.get(j)], StorageType.RAM_DISK);
            }
        }
        this.verifyRamDiskJMXMetric("RamDiskBlocksWrite", 10L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksWriteFallback", 0L);
        this.verifyRamDiskJMXMetric("RamDiskBytesWrite", 0x3200000L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksReadHits", 5L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 5L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvictedWithoutRead", 0L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksDeletedBeforeLazyPersisted", 0L);
    }

    @Test
    public void testDeleteBeforePersist() throws Exception {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.client.delete(path.toString(), false);
        Assert.assertFalse((boolean)this.fs.exists(path));
        Assert.assertThat((Object)this.verifyDeletedBlocks(locatedBlocks), (Matcher)Is.is((Object)true));
        this.verifyRamDiskJMXMetric("RamDiskBlocksDeletedBeforeLazyPersisted", 1L);
    }

    @Test
    public void testDeleteAfterPersist() throws Exception {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        Thread.sleep(6000L);
        this.client.delete(path.toString(), false);
        Assert.assertFalse((boolean)this.fs.exists(path));
        Assert.assertThat((Object)this.verifyDeletedBlocks(locatedBlocks), (Matcher)Is.is((Object)true));
        this.verifyRamDiskJMXMetric("RamDiskBlocksLazyPersisted", 1L);
        this.verifyRamDiskJMXMetric("RamDiskBytesLazyPersisted", 0x500000L);
    }

    @Test
    public void testDfsUsageCreateDelete() throws IOException, InterruptedException {
        this.startUpCluster(true, 4);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        long usedBeforeCreate = this.fs.getUsed();
        this.makeTestFile(path, 0x500000L, true);
        long usedAfterCreate = this.fs.getUsed();
        Assert.assertThat((Object)usedAfterCreate, (Matcher)Is.is((Object)0x500000L));
        Thread.sleep(3000L);
        long usedAfterPersist = this.fs.getUsed();
        Assert.assertThat((Object)usedAfterPersist, (Matcher)Is.is((Object)0x500000L));
        this.client.delete(path.toString(), false);
        long usedAfterDelete = this.fs.getUsed();
        Assert.assertThat((Object)usedBeforeCreate, (Matcher)Is.is((Object)usedAfterDelete));
    }

    @Test
    public void testConcurrentRead() throws Exception {
        int i;
        this.startUpCluster(true, 2);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        final Path path1 = new Path("/" + METHOD_NAME + ".dat");
        int SEED = 1027565;
        int NUM_TASKS = 5;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        final CountDownLatch latch = new CountDownLatch(5);
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        Runnable readerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Assert.assertTrue((boolean)TestLazyPersistFiles.this.verifyReadRandomFile(path1, 0x500000, 1027565));
                }
                catch (Throwable e) {
                    LazyPersistTestCase.LOG.error((Object)"readerRunnable error", e);
                    testFailed.set(true);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new Thread(readerRunnable);
            threads[i].start();
        }
        Thread.sleep(500L);
        for (i = 0; i < 5; ++i) {
            Uninterruptibles.joinUninterruptibly((Thread)threads[i]);
        }
        Assert.assertFalse((boolean)testFailed.get());
    }

    @Test
    public void testConcurrentWrites() throws IOException, InterruptedException {
        this.startUpCluster(true, 9);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        int SEED = 1027565;
        int NUM_WRITERS = 4;
        int NUM_WRITER_PATHS = 5;
        Path[][] paths = new Path[4][5];
        for (int i = 0; i < 4; ++i) {
            paths[i] = new Path[5];
            for (int j = 0; j < 5; ++j) {
                paths[i][j] = new Path("/" + METHOD_NAME + ".Writer" + i + ".File." + j + ".dat");
            }
        }
        CountDownLatch latch = new CountDownLatch(4);
        AtomicBoolean testFailed = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 4; ++i) {
            WriterRunnable writer = new WriterRunnable(i, paths[i], 1027565, latch, testFailed);
            executor.execute(writer);
        }
        Thread.sleep(3000L);
        this.triggerBlockReport();
        latch.await();
        Assert.assertThat((Object)testFailed.get(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDnRestartWithSavedReplicas() throws IOException, InterruptedException {
        this.startUpCluster(true, -1);
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        Thread.sleep(3000L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info((Object)"Restarting the DataNode");
        this.cluster.restartDataNode(0, true);
        this.cluster.waitActive();
        this.triggerBlockReport();
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
    }

    @Test
    public void testDnRestartWithUnsavedReplicas() throws IOException, InterruptedException {
        this.startUpCluster(true, 1);
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        LOG.info((Object)"Restarting the DataNode");
        this.cluster.restartDataNode(0, true);
        this.cluster.waitActive();
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
    }

    class WriterRunnable
    implements Runnable {
        private final int id;
        private final Path[] paths;
        private final int seed;
        private CountDownLatch latch;
        private AtomicBoolean bFail;

        public WriterRunnable(int threadIndex, Path[] paths, int seed, CountDownLatch latch, AtomicBoolean bFail) {
            this.id = threadIndex;
            this.paths = paths;
            this.seed = seed;
            this.latch = latch;
            this.bFail = bFail;
            System.out.println("Creating Writer: " + this.id);
        }

        @Override
        public void run() {
            System.out.println("Writer " + this.id + " starting... ");
            int i = 0;
            try {
                for (i = 0; i < this.paths.length; ++i) {
                    TestLazyPersistFiles.this.makeRandomTestFile(this.paths[i], 0x500000L, true, this.seed);
                }
            }
            catch (IOException e) {
                this.bFail.set(true);
                LazyPersistTestCase.LOG.error((Object)("Writer exception: writer id:" + this.id + " testfile: " + this.paths[i].toString() + " " + e));
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

