/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.HashMap;
import java.util.Locale;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSourceFactory;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSourceImpl;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;

@InterfaceAudience.Private
public class MetricsHBaseServerSourceFactoryImpl
extends MetricsHBaseServerSourceFactory {
    public MetricsHBaseServerSource create(String serverName, MetricsHBaseServerWrapper wrapper) {
        return MetricsHBaseServerSourceFactoryImpl.getSource(serverName, wrapper);
    }

    private static synchronized MetricsHBaseServerSource getSource(String serverName, MetricsHBaseServerWrapper wrap) {
        String context = MetricsHBaseServerSourceFactoryImpl.createContextName((String)serverName);
        MetricsHBaseServerSource source = SourceStorage.INSTANCE.sources.get(context);
        if (source == null) {
            source = new MetricsHBaseServerSourceImpl(context, "Metrics about HBase Server IPC", context.toLowerCase(Locale.ROOT), context + ",sub=IPC", wrap);
            SourceStorage.INSTANCE.sources.put(context, source);
        }
        return source;
    }

    private static enum SourceStorage {
        INSTANCE;

        HashMap<String, MetricsHBaseServerSource> sources = new HashMap();
    }
}

