/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestResultFromCoprocessor {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW = Bytes.toBytes((String)"normal_row");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fm");
    private static final byte[] QUAL = Bytes.toBytes((String)"qual");
    private static final byte[] VALUE = Bytes.toBytes((long)100L);
    private static final byte[] FIXED_VALUE = Bytes.toBytes((String)"fixed_value");
    private static final Cell FIXED_CELL = CellUtil.createCell((byte[])ROW, (byte[])FAMILY, (byte[])QUAL, (long)0L, (byte)KeyValue.Type.Put.getCode(), (byte[])FIXED_VALUE);
    private static final Result FIXED_RESULT = Result.create(Arrays.asList(FIXED_CELL));
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestResultFromCoprocessor");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        desc.addCoprocessor(MyObserver.class.getName()).addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getHBaseAdmin().createTable(desc);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAppend() throws IOException {
        try (Table t = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUAL, VALUE);
            t.put(put);
            TestResultFromCoprocessor.assertRowAndValue(t.get(new Get(ROW)), ROW, VALUE);
            Append append = new Append(ROW);
            append.add(FAMILY, QUAL, FIXED_VALUE);
            TestResultFromCoprocessor.assertRowAndValue(t.append(append), ROW, FIXED_VALUE);
            TestResultFromCoprocessor.assertRowAndValue(t.get(new Get(ROW)), ROW, Bytes.add((byte[])VALUE, (byte[])FIXED_VALUE));
        }
    }

    @Test
    public void testIncrement() throws IOException {
        try (Table t = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUAL, VALUE);
            t.put(put);
            TestResultFromCoprocessor.assertRowAndValue(t.get(new Get(ROW)), ROW, VALUE);
            Increment inc = new Increment(ROW);
            inc.addColumn(FAMILY, QUAL, 99L);
            TestResultFromCoprocessor.assertRowAndValue(t.increment(inc), ROW, FIXED_VALUE);
            TestResultFromCoprocessor.assertRowAndValue(t.get(new Get(ROW)), ROW, Bytes.toBytes((long)199L));
        }
    }

    private static void assertRowAndValue(Result r, byte[] row, byte[] value) {
        for (Cell c : r.rawCells()) {
            TestCase.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)c), (byte[])row));
            TestCase.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)c), (byte[])value));
        }
    }

    public static class MyObserver
    extends BaseRegionObserver {
        public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) {
            return FIXED_RESULT;
        }

        public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) {
            return FIXED_RESULT;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }
    }
}

