/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestLogsCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        CleanerChore.initChorePool((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        long ttl = 10000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttl);
        conf.setBoolean("hbase.replication", true);
        Replication.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ZooKeeperWatcher)server.getZooKeeper(), (Configuration)conf, (Abortable)server);
        repQueues.init(server.getServerName().toString());
        final Path oldLogDir = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), "UTF8");
        final FileSystem fs = FileSystem.get((Configuration)conf);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + "a"));
        System.out.println("Now is: " + now);
        for (int i = 1; i < 31; ++i) {
            Path fileName = new Path(oldLogDir, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 1) continue;
            repQueues.addLog(fakeMachineName, fileName.getName());
            System.out.println("Replication log file: " + fileName);
        }
        Thread.sleep(ttl);
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + 10000L)));
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            System.out.println(stat.getPath().toString());
        }
        Assert.assertEquals((long)34L, (long)fs.listStatus(oldLogDir).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return 5 == fs.listStatus(oldLogDir).length;
            }
        });
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            System.out.println("Kept log files: " + file.getPath().getName());
        }
    }

    @Test(timeout=5000L)
    public void testZnodeCversionChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        cleaner.setConf(conf);
        ReplicationQueuesClient rqcMock = (ReplicationQueuesClient)Mockito.mock(ReplicationQueuesClient.class);
        Mockito.when((Object)rqcMock.getQueuesZNodeCversion()).thenReturn((Object)1, (Object[])new Integer[]{2, 3, 4});
        Field rqc = ReplicationLogCleaner.class.getDeclaredField("replicationQueues");
        rqc.setAccessible(true);
        rqc.set(cleaner, rqcMock);
        cleaner.getDeletableFiles(new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testZooKeeperAbortDuringGetListOfReplicators() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        ArrayList dummyFiles = Lists.newArrayList((Object[])new FileStatus[]{new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2"))});
        final AtomicBoolean getListOfReplicatorsFailed = new AtomicBoolean(false);
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            ReplicationQueuesClient replicationQueuesClient = (ReplicationQueuesClient)Mockito.spy((Object)ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)faultyZK, (Configuration)conf, (Abortable)new ReplicationLogCleaner.WarnOnlyAbortable()));
            ((ReplicationQueuesClient)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    try {
                        return invocation.callRealMethod();
                    }
                    catch (KeeperException.ConnectionLossException e) {
                        getListOfReplicatorsFailed.set(true);
                        throw e;
                    }
                }
            }).when((Object)replicationQueuesClient)).getListOfReplicators();
            replicationQueuesClient.init();
            cleaner.setConf(conf, (ZooKeeperWatcher)faultyZK, replicationQueuesClient);
            Iterable toDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Assert.assertTrue((boolean)getListOfReplicatorsFailed.get());
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testZooKeeperNormal() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        ArrayList dummyFiles = Lists.newArrayList((Object[])new FileStatus[]{new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2"))});
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            Iterable filesToDelete = cleaner.getDeletableFiles((Iterable)dummyFiles);
            Iterator iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log1"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log2"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void testOnConfigurationChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.oldwals.cleaner.thread.size", 2);
        DummyServer server = new DummyServer();
        Path oldWALsDir = new Path(TEST_UTIL.getDefaultRootDirPath(), "oldWALs");
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        final LogCleaner cleaner = new LogCleaner(3000, (Stoppable)server, conf, (FileSystem)fs, oldWALsDir);
        Assert.assertEquals((long)2L, (long)cleaner.getSizeOfCleaners());
        fs.delete(oldWALsDir, true);
        fs.mkdirs(oldWALsDir);
        int numOfFiles = 10;
        this.createFiles((FileSystem)fs, oldWALsDir, numOfFiles);
        FileStatus[] status = fs.listStatus(oldWALsDir);
        Assert.assertEquals((long)numOfFiles, (long)status.length);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                cleaner.chore();
            }
        });
        thread.setDaemon(true);
        thread.start();
        int sizeToChange = 4;
        conf.setInt("hbase.oldwals.cleaner.thread.size", sizeToChange);
        cleaner.onConfigurationChange(conf);
        Assert.assertEquals((long)sizeToChange, (long)cleaner.getSizeOfCleaners());
        thread.join();
        status = fs.listStatus(oldWALsDir);
        Assert.assertEquals((long)0L, (long)status.length);
    }

    private void createFiles(FileSystem fs, Path parentDir, int numOfFiles) throws IOException {
        Random random = new Random();
        for (int i = 0; i < numOfFiles; ++i) {
            int xMega = 1 + random.nextInt(3);
            try (FSDataOutputStream fsdos = fs.create(new Path(parentDir, "file-" + i));){
                for (int m = 0; m < xMega; ++m) {
                    byte[] M = new byte[0x100000];
                    random.nextBytes(M);
                    fsdos.write(M);
                }
                continue;
            }
        }
    }

    static class FaultyZooKeeperWatcher
    extends ZooKeeperWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)this.zk)).getChildren("/hbase/replication/rs", null);
        }

        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }
    }
}

