/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.security.Permission;

public class LauncherSecurityManager
extends SecurityManager {
    private int exitCode;
    private SecurityManager securityManager;

    public LauncherSecurityManager() {
        this(null);
    }

    public LauncherSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
        this.reset();
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.securityManager != null) {
            this.securityManager.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.securityManager != null) {
            this.securityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkExit(int status) throws SecurityException {
        this.exitCode = status;
        throw new SecurityException("Intercepted System.exit(" + status + ")");
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void reset() {
        this.exitCode = 0;
    }
}

