/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5HexAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(MD5HexAssertion.class);
    private static final String MD5HEX_KEY = "MD5HexAssertion.size";

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        byte[] resultData = response.getResponseData();
        if (resultData.length == 0) {
            result.setError(false);
            result.setFailure(true);
            result.setFailureMessage("Response was null");
            return result;
        }
        if (this.getAllowedMD5Hex().isEmpty()) {
            result.setError(false);
            result.setFailure(true);
            result.setFailureMessage("MD5Hex to test against is empty");
            return result;
        }
        String md5Result = MD5HexAssertion.baMD5Hex(resultData);
        if (!md5Result.equalsIgnoreCase(this.getAllowedMD5Hex())) {
            result.setFailure(true);
            Object[] arguments = new Object[]{md5Result, this.getAllowedMD5Hex()};
            String message = MessageFormat.format(JMeterUtils.getResString((String)"md5hex_assertion_failure"), arguments);
            result.setFailureMessage(message);
        }
        return result;
    }

    public void setAllowedMD5Hex(String hex) {
        this.setProperty((JMeterProperty)new StringProperty(MD5HEX_KEY, hex));
    }

    public String getAllowedMD5Hex() {
        return this.getPropertyAsString(MD5HEX_KEY);
    }

    static String baMD5Hex(byte[] ba) {
        byte[] md5Result = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md5Result = md.digest(ba);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Message digestion failed.", (Throwable)e);
        }
        return JOrphanUtils.baToHexString((byte[])md5Result);
    }
}

