/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRendererWrapper;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.Calculator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.StatGraphVisualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.ObjectTableSorter;
import org.apache.jorphan.gui.RateRenderer;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.reflect.Functor;

public class SummaryReport
extends AbstractVisualizer
implements Clearable,
ActionListener {
    private static final long serialVersionUID = 241L;
    private static final String USE_GROUP_NAME = "useGroupName";
    private static final String SAVE_HEADERS = "saveHeaders";
    private static final String[] COLUMNS = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_min", "aggregate_report_max", "aggregate_report_stddev", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth", "aggregate_report_sent_bytes_per_sec", "average_bytes"};
    private final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private static final int REFRESH_PERIOD = JMeterUtils.getPropDefault((String)"jmeter.gui.refresh_period", (int)500);
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private final JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private final JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"), true);
    private final JCheckBox useGroupName = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_use_group_name"));
    private transient ObjectTableModel model;
    private final transient Object lock = new Object();
    private volatile boolean dataChanged;
    private final Map<String, Calculator> tableRows = new ConcurrentHashMap<String, Calculator>();
    private final Deque<Calculator> newRows = new ConcurrentLinkedDeque<Calculator>();
    private static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, null, null, null, null, new NumberRenderer("#0.00"), new NumberRenderer("#0.00%"), new RateRenderer("#.0"), new NumberRenderer("#0.00"), new NumberRenderer("#0.00"), new NumberRenderer("#.0")};
    private static final Format[] FORMATS = new Format[]{null, null, null, null, null, new DecimalFormat("#0.00"), new DecimalFormat("#0.000%"), new DecimalFormat("#.00000"), new DecimalFormat("#0.00"), new DecimalFormat("#0.00"), new DecimalFormat("#.0")};

    public SummaryReport() {
        this.model = new ObjectTableModel(COLUMNS, Calculator.class, new Functor[]{new Functor("getLabel"), new Functor("getCount"), new Functor("getMeanAsNumber"), new Functor("getMin"), new Functor("getMax"), new Functor("getStandardDeviation"), new Functor("getErrorPercentage"), new Functor("getRate"), new Functor("getKBPerSecond"), new Functor("getSentKBPerSecond"), new Functor("getAvgPageBytes")}, new Functor[]{null, null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, Integer.class, Long.class, Long.class, Long.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class});
        this.clearData();
        this.init();
        new Timer(REFRESH_PERIOD, e -> {
            if (!this.dataChanged) {
                return;
            }
            this.dataChanged = false;
            Object object = this.lock;
            synchronized (object) {
                while (!this.newRows.isEmpty()) {
                    this.model.insertRow((Object)this.newRows.pop(), this.model.getRowCount() - 1);
                }
                this.model.fireTableDataChanged();
            }
        }).start();
    }

    @Deprecated
    public static boolean testFunctors() {
        SummaryReport instance = new SummaryReport();
        return instance.model.checkFunctors(null, instance.getClass());
    }

    public String getLabelResource() {
        return "summary_report";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult res) {
        Calculator row;
        Calculator calculator = row = this.tableRows.computeIfAbsent(res.getSampleLabel(this.useGroupName.isSelected()), label -> {
            Calculator newRow = new Calculator(label);
            this.newRows.add(newRow);
            return newRow;
        });
        synchronized (calculator) {
            row.addSample(res);
        }
        Calculator tot = this.tableRows.get(this.TOTAL_ROW_LABEL);
        Object object = this.lock;
        synchronized (object) {
            tot.addSample(res);
        }
        this.dataChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.model.clearData();
            this.newRows.clear();
            this.tableRows.clear();
            this.tableRows.put(this.TOTAL_ROW_LABEL, new Calculator(this.TOTAL_ROW_LABEL));
            this.model.addRow((Object)this.tableRows.get(this.TOTAL_ROW_LABEL));
        }
        this.dataChanged = true;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myJTable = new JTable((TableModel)this.model);
        this.myJTable.setRowSorter((RowSorter<? extends TableModel>)new ObjectTableSorter(this.model).fixLastRow());
        JMeterUtils.applyHiDPI((JTable)this.myJTable);
        HeaderAsPropertyRendererWrapper.setupDefaultRenderer((JTable)this.myJTable);
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])RENDERERS);
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
        this.saveTable.addActionListener(this);
        JPanel opts = new JPanel();
        opts.add((Component)this.useGroupName, "West");
        opts.add((Component)this.saveTable, "Center");
        opts.add((Component)this.saveHeaders, "East");
        this.add(opts, "South");
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(USE_GROUP_NAME, this.useGroupName.isSelected(), false);
        c.setProperty(SAVE_HEADERS, this.saveHeaders.isSelected(), true);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.useGroupName.setSelected(el.getPropertyAsBoolean(USE_GROUP_NAME, false));
        this.saveHeaders.setSelected(el.getPropertyAsBoolean(SAVE_HEADERS, true));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.saveTable) {
            JFileChooser chooser = FileDialoger.promptToSaveFile((String)"summary.csv");
            if (chooser == null) {
                return;
            }
            try (FileOutputStream fo = new FileOutputStream(chooser.getSelectedFile());
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fo, Charset.forName("UTF-8"));){
                CSVSaveService.saveCSVStats(StatGraphVisualizer.getAllTableData(this.model, FORMATS), (Writer)writer, (String[])(this.saveHeaders.isSelected() ? StatGraphVisualizer.getLabels(COLUMNS) : null));
            }
            catch (IOException e) {
                JMeterUtils.reportErrorToUser((String)e.getMessage(), (String)"Error saving data");
            }
        }
    }
}

