/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendListenerContext {
    private static final Logger log = LoggerFactory.getLogger(BackendListenerContext.class);
    private final Map<String, String> params;

    public BackendListenerContext(Arguments args) {
        this.params = args.getArgumentsAsMap();
    }

    public boolean containsParameter(String name) {
        return this.params.containsKey(name);
    }

    public Iterator<String> getParameterNamesIterator() {
        return this.params.keySet().iterator();
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public String getParameter(String name, String defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        return this.params.get(name);
    }

    public int getIntParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new IllegalArgumentException("No value for parameter named '" + name + "'.");
        }
        return Integer.parseInt(this.params.get(name));
    }

    public int getIntParameter(String name, int defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        String valueString = this.params.get(name);
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            log.warn("Value for parameter '{}' not an integer: '{}'.  Using default: '{}'.", new Object[]{name, valueString, defaultValue, e});
            return defaultValue;
        }
    }

    public long getLongParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new NumberFormatException("No value for parameter named '" + name + "'.");
        }
        return Long.parseLong(this.params.get(name));
    }

    public long getLongParameter(String name, long defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        String valueString = this.params.get(name);
        try {
            return Long.decode(valueString);
        }
        catch (NumberFormatException e) {
            log.warn("Value for parameter '{}' not a long: '{}'.  Using default: '{}'.", new Object[]{name, valueString, defaultValue, e});
            return defaultValue;
        }
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.params.get(name));
    }
}

