/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.AbstractKTableKTableJoinValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class KTableKTableRightJoin<K, R, V1, V2>
extends KTableKTableAbstractJoin<K, R, V1, V2> {
    KTableKTableRightJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<? super V1, ? super V2, ? extends R> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>> get() {
        return new KTableKTableRightJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, R> view() {
        return new KTableKTableRightJoinValueGetterSupplier(this.valueGetterSupplier1, this.valueGetterSupplier2);
    }

    private class KTableKTableRightJoinValueGetter
    implements KTableValueGetter<K, R> {
        private final KTableValueGetter<K, V1> valueGetter1;
        private final KTableValueGetter<K, V2> valueGetter2;

        public KTableKTableRightJoinValueGetter(KTableValueGetter<K, V1> valueGetter1, KTableValueGetter<K, V2> valueGetter2) {
            this.valueGetter1 = valueGetter1;
            this.valueGetter2 = valueGetter2;
        }

        @Override
        public void init(ProcessorContext context) {
            this.valueGetter1.init(context);
            this.valueGetter2.init(context);
        }

        @Override
        public R get(K key) {
            Object value2 = this.valueGetter2.get(key);
            if (value2 != null) {
                Object value1 = this.valueGetter1.get(key);
                return KTableKTableRightJoin.this.joiner.apply(value1, value2);
            }
            return null;
        }
    }

    private class KTableKTableRightJoinProcessor
    extends AbstractProcessor<K, Change<V1>> {
        private final KTableValueGetter<K, V2> valueGetter;

        public KTableKTableRightJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueGetter.init(context);
        }

        @Override
        public void process(K key, Change<V1> change) {
            if (key == null) {
                return;
            }
            Object oldValue = null;
            Object value2 = this.valueGetter.get(key);
            if (value2 == null) {
                return;
            }
            Object newValue = KTableKTableRightJoin.this.joiner.apply(change.newValue, value2);
            if (KTableKTableRightJoin.this.sendOldValues) {
                oldValue = KTableKTableRightJoin.this.joiner.apply(change.oldValue, value2);
            }
            this.context().forward(key, new Change<Object>(newValue, oldValue));
        }
    }

    private class KTableKTableRightJoinValueGetterSupplier
    extends AbstractKTableKTableJoinValueGetterSupplier<K, R, V1, V2> {
        public KTableKTableRightJoinValueGetterSupplier(KTableValueGetterSupplier<K, V1> valueGetterSupplier1, KTableValueGetterSupplier<K, V2> valueGetterSupplier2) {
            super(valueGetterSupplier1, valueGetterSupplier2);
        }

        @Override
        public KTableValueGetter<K, R> get() {
            return new KTableKTableRightJoinValueGetter(this.valueGetterSupplier1.get(), this.valueGetterSupplier2.get());
        }
    }
}

