/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;

public class KStreamTransformValues<K, V, R>
implements ProcessorSupplier<K, V> {
    private final ValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier;

    KStreamTransformValues(ValueTransformerWithKeySupplier<K, V, R> valueTransformerSupplier) {
        this.valueTransformerSupplier = valueTransformerSupplier;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamTransformValuesProcessor<K, V, R>(this.valueTransformerSupplier.get());
    }

    public static class KStreamTransformValuesProcessor<K, V, R>
    implements Processor<K, V> {
        private final ValueTransformerWithKey<K, V, R> valueTransformer;
        private ProcessorContext context;

        KStreamTransformValuesProcessor(ValueTransformerWithKey<K, V, R> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext context) {
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(context));
            this.context = context;
        }

        @Override
        public void process(K key, V value) {
            this.context.forward(key, this.valueTransformer.transform(key, value));
        }

        @Override
        public void close() {
            this.valueTransformer.close();
        }
    }
}

