/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.NamedCache;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.slf4j.Logger;

public class ThreadCache {
    private final Logger log;
    private final long maxCacheSizeBytes;
    private final StreamsMetricsImpl metrics;
    private final Map<String, NamedCache> caches = new HashMap<String, NamedCache>();
    private long numPuts = 0L;
    private long numGets = 0L;
    private long numEvicts = 0L;
    private long numFlushes = 0L;

    public ThreadCache(LogContext logContext, long maxCacheSizeBytes, StreamsMetricsImpl metrics) {
        this.maxCacheSizeBytes = maxCacheSizeBytes;
        this.metrics = metrics;
        this.log = logContext.logger(this.getClass());
    }

    public long puts() {
        return this.numPuts;
    }

    public long gets() {
        return this.numGets;
    }

    public long evicts() {
        return this.numEvicts;
    }

    public long flushes() {
        return this.numFlushes;
    }

    public static String nameSpaceFromTaskIdAndStore(String taskIDString, String underlyingStoreName) {
        return taskIDString + "-" + underlyingStoreName;
    }

    public static String taskIDfromCacheName(String cacheName) {
        String[] tokens = cacheName.split("-", 2);
        return tokens[0];
    }

    public static String underlyingStoreNamefromCacheName(String cacheName) {
        String[] tokens = cacheName.split("-", 2);
        return tokens[1];
    }

    public void addDirtyEntryFlushListener(String namespace, DirtyEntryFlushListener listener) {
        NamedCache cache = this.getOrCreateCache(namespace);
        cache.setListener(listener);
    }

    public void flush(String namespace) {
        ++this.numFlushes;
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return;
        }
        cache.flush();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Cache stats on flush: #puts={}, #gets={}, #evicts={}, #flushes={}", new Object[]{this.puts(), this.gets(), this.evicts(), this.flushes()});
        }
    }

    public LRUCacheEntry get(String namespace, Bytes key) {
        ++this.numGets;
        if (key == null) {
            return null;
        }
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return null;
        }
        return cache.get(key);
    }

    public void put(String namespace, Bytes key, LRUCacheEntry value) {
        ++this.numPuts;
        NamedCache cache = this.getOrCreateCache(namespace);
        cache.put(key, value);
        this.maybeEvict(namespace);
    }

    public LRUCacheEntry putIfAbsent(String namespace, Bytes key, LRUCacheEntry value) {
        NamedCache cache = this.getOrCreateCache(namespace);
        LRUCacheEntry result = cache.putIfAbsent(key, value);
        this.maybeEvict(namespace);
        if (result == null) {
            ++this.numPuts;
        }
        return result;
    }

    public void putAll(String namespace, List<KeyValue<Bytes, LRUCacheEntry>> entries) {
        for (KeyValue<Bytes, LRUCacheEntry> entry : entries) {
            this.put(namespace, (Bytes)entry.key, (LRUCacheEntry)entry.value);
        }
    }

    public LRUCacheEntry delete(String namespace, Bytes key) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return null;
        }
        return cache.delete(key);
    }

    public MemoryLRUCacheBytesIterator range(String namespace, Bytes from, Bytes to) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.keyRange(from, to), cache);
    }

    public MemoryLRUCacheBytesIterator all(String namespace) {
        NamedCache cache = this.getCache(namespace);
        if (cache == null) {
            return new MemoryLRUCacheBytesIterator(Collections.emptyIterator(), new NamedCache(namespace, this.metrics));
        }
        return new MemoryLRUCacheBytesIterator(cache.allKeys(), cache);
    }

    public long size() {
        long size = 0L;
        for (NamedCache cache : this.caches.values()) {
            if (!this.isOverflowing(size += cache.size())) continue;
            return Long.MAX_VALUE;
        }
        return size;
    }

    private boolean isOverflowing(long size) {
        return size < 0L;
    }

    long sizeBytes() {
        long sizeInBytes = 0L;
        for (NamedCache namedCache : this.caches.values()) {
            if (!this.isOverflowing(sizeInBytes += namedCache.sizeInBytes())) continue;
            return Long.MAX_VALUE;
        }
        return sizeInBytes;
    }

    synchronized void close(String namespace) {
        NamedCache removed = this.caches.remove(namespace);
        if (removed != null) {
            removed.close();
        }
    }

    private void maybeEvict(String namespace) {
        int numEvicted = 0;
        while (this.sizeBytes() > this.maxCacheSizeBytes) {
            NamedCache cache = this.getOrCreateCache(namespace);
            if (cache.size() == 0L) {
                return;
            }
            cache.evict();
            ++this.numEvicts;
            ++numEvicted;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Evicted {} entries from cache {}", (Object)numEvicted, (Object)namespace);
        }
    }

    private synchronized NamedCache getCache(String namespace) {
        return this.caches.get(namespace);
    }

    private synchronized NamedCache getOrCreateCache(String name) {
        NamedCache cache = this.caches.get(name);
        if (cache == null) {
            cache = new NamedCache(name, this.metrics);
            this.caches.put(name, cache);
        }
        return cache;
    }

    static class DirtyEntry {
        private final Bytes key;
        private final byte[] newValue;
        private final ProcessorRecordContext recordContext;

        DirtyEntry(Bytes key, byte[] newValue, ProcessorRecordContext recordContext) {
            this.key = key;
            this.newValue = newValue;
            this.recordContext = recordContext;
        }

        public Bytes key() {
            return this.key;
        }

        public byte[] newValue() {
            return this.newValue;
        }

        public ProcessorRecordContext recordContext() {
            return this.recordContext;
        }
    }

    static class MemoryLRUCacheBytesIterator
    implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
        private final Iterator<Bytes> keys;
        private final NamedCache cache;
        private KeyValue<Bytes, LRUCacheEntry> nextEntry;

        MemoryLRUCacheBytesIterator(Iterator<Bytes> keys, NamedCache cache) {
            this.keys = keys;
            this.cache = cache;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (Bytes)this.nextEntry.key;
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextEntry;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            while (this.keys.hasNext() && this.nextEntry == null) {
                this.internalNext();
            }
            return this.nextEntry != null;
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue<Bytes, LRUCacheEntry> result = this.nextEntry;
            this.nextEntry = null;
            return result;
        }

        private void internalNext() {
            Bytes cacheKey = this.keys.next();
            LRUCacheEntry entry = this.cache.get(cacheKey);
            if (entry == null) {
                return;
            }
            this.nextEntry = new KeyValue<Bytes, LRUCacheEntry>(cacheKey, entry);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported by MemoryLRUCacheBytesIterator");
        }

        @Override
        public void close() {
        }
    }

    public static interface DirtyEntryFlushListener {
        public void apply(List<DirtyEntry> var1);
    }
}

