/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.PartitionFetchState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u0001\u001d\u0011QcQ8ogVlWM\u001d$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\t9\fW.\u001a\t\u0003#iq!A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011A\u0002\u001fs_>$hHC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0011!q\u0002A!b\u0001\n\u0003y\u0012AB2p]\u001aLw-F\u0001!!\t\t#%D\u0001\u0003\u0013\t\u0019#A\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0001\nqaY8oM&<\u0007\u0005C\u0005(\u0001\t\u0005\t\u0015!\u0003)]\u0005a1o\\;sG\u0016\u0014%o\\6feB\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\bG2,8\u000f^3s\u0013\ti#F\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\n\u0005\u001db\u0001\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\tI*tGQ\u0007\u0002g)\u0011AGF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001c4\u0005\ri\u0015\r\u001d\t\u0003q\u0001k\u0011!\u000f\u0006\u0003um\naaY8n[>t'BA\u0003=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005K$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003C\rK!\u0001\u0012\u0002\u0003%A\u000b'\u000f^5uS>tGk\u001c9jG&sgm\u001c\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\u000612m\u001c8tk6,'OR3uG\",'/T1oC\u001e,'/F\u0001I!\t\t\u0013*\u0003\u0002K\u0005\t12i\u001c8tk6,'OR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003I\u0003]\u0019wN\\:v[\u0016\u0014h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\u0007!F\u00136\u000bV+\u0011\u0005\u0005\u0002\u0001\"B\bN\u0001\u0004\u0001\u0002\"\u0002\u0010N\u0001\u0004\u0001\u0003\"B\u0014N\u0001\u0004A\u0003\"\u0002\u0019N\u0001\u0004\t\u0004\"\u0002$N\u0001\u0004AU\u0001B,\u0001\u0001a\u00131AU#R!\tIVM\u0004\u0002\"5\u001e)1L\u0001E\u00019\u0006)2i\u001c8tk6,'OR3uG\",'\u000f\u00165sK\u0006$\u0007CA\u0011^\r\u0015\t!\u0001#\u0001_'\tiv\f\u0005\u0002aC6\ta#\u0003\u0002c-\t1\u0011I\\=SK\u001aDQAT/\u0005\u0002\u0011$\u0012\u0001\u0018\u0004\u0005Mv\u0003qM\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cHoE\u0002f?\"\u0004\"!\u001b7\u000f\u0005%Q\u0017BA6\u000b\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012L!AZ7\u000b\u0005-T\u0001\u0002C8f\u0005\u000b\u0007I\u0011\u00019\u0002\u0015UtG-\u001a:ms&tw-F\u0001r!\t\u0011X/D\u0001t\u0015\t!H!A\u0002ba&L!AZ:\t\u0011],'\u0011!Q\u0001\nE\f1\"\u001e8eKJd\u00170\u001b8hA!)a*\u001aC\u0001sR\u0011!\u0010 \t\u0003w\u0016l\u0011!\u0018\u0005\u0006_b\u0004\r!\u001d\u0005\t}\u0016D)\u0019!C\u0005\u007f\u0006QA\u000f\u001d+p\u001f\u001a47/\u001a;\u0016\u0005\u0005\u0005\u0001#\u0002\u001a6o\u0005\r\u0001c\u00011\u0002\u0006%\u0019\u0011q\u0001\f\u0003\t1{gn\u001a\u0005\b\u0003\u0017)G\u0011AA\u0007\u0003\u001dI7/R7qif,\"!a\u0004\u0011\u0007\u0001\f\t\"C\u0002\u0002\u0014Y\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0018\u0015$\t!!\u0007\u0002\r=4gm]3u)\u0011\t\u0019!a\u0007\t\u000f\u0005u\u0011Q\u0003a\u0001o\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\u0011K\u0012\u0005\u00131E\u0001\ti>\u001cFO]5oOR\t\u0001C\u0002\u0004\u0002(u\u0003\u0011\u0011\u0006\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0014\u000b\u0005\u0015r,a\u000b\u0011\u0007%\fi#C\u0002\u0002(5D!b\\A\u0013\u0005\u000b\u0007I\u0011AA\u0019+\t\t\u0019\u0004E\u0002s\u0003kI1!a\u000et\u0005i1U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>tG)\u0019;b\u0011)9\u0018Q\u0005B\u0001B\u0003%\u00111\u0007\u0005\b\u001d\u0006\u0015B\u0011AA\u001f)\u0011\ty$!\u0011\u0011\u0007m\f)\u0003C\u0004p\u0003w\u0001\r!a\r\t\u0011\u0005\u0015\u0013Q\u0005C\u0001\u0003\u000f\nQ!\u001a:s_J,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014:\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA*\u0003\u001b\u0012a!\u0012:s_J\u001c\b\u0002CA,\u0003K!\t!!\u0017\u0002\u0013Q|'+Z2pe\u0012\u001cXCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1s\u00051!/Z2pe\u0012LA!!\u001a\u0002`\tiQ*Z7pef\u0014VmY8sIND\u0001\"!\u001b\u0002&\u0011\u0005\u00111N\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0016\u0005\u0005\r\u0001\u0002CA8\u0003K!\t!!\u001d\u0002\u0013\u0015D8-\u001a9uS>tWCAA:!\u0015\u0001\u0017QOA=\u0013\r\t9H\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u0014Q\u0011\b\u0005\u0003{\n\tID\u0002\u0014\u0003\u007fJ\u0011aF\u0005\u0004\u0003\u00073\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\u000bIIA\u0005UQJ|w/\u00192mK*\u0019\u00111\u0011\f\t\u0011\u0005\u0005\u0012Q\u0005C!\u0003\u001b#\"!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006!A.\u00198h\u0015\t\tI*\u0001\u0003kCZ\f\u0017bA\u000e\u0002\u0014\":Q,a(\u0002&\u0006%\u0006c\u00011\u0002\"&\u0019\u00111\u0015\f\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002(\u0006\t\t\u0003\u00165jg\u0002z'M[3di\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018!!2,\u0017m]3!kN,\u0007e\u001c:h]\u0005\u0004\u0018m\u00195f]-\fgm[1/G2LWM\u001c;t]\r|gn];nKJt\u0013N\u001c;fe:\fGn\u001d\u0018GKR\u001c\u0007.\u001a:!S:\u001cH/Z1e]\u0005\u0012\u00111V\u0001\ta9\n\u0014G\f\u0019/a!:Q,a(\u00020\u0006%\u0016EAAY\u0003\u0005}A\u000b[5tA\rd\u0017m]:!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g\u0006\t)mK\u0006\u001cX\rI;tK\u0002z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018lC\u001a\\\u0017ML2mS\u0016tGo\u001d\u0018d_:\u001cX/\\3s]%tG/\u001a:oC2\u001chFR3uG\",'\u000fI5ogR,\u0017\r\u001a\u0018)\u000fi\u000by*!*\u0002*\u00161\u0011q\u0017\u0001\u0001\u0003s\u0013!\u0001\u0015#\u0011\u0007e\u000b)\u0003C\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002@\u0006A1\r\\5f]RLE-F\u0001\u0011\u0011\u001d\t\u0019\r\u0001Q\u0001\nA\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u0013\u0005\u001d\u0007A1A\u0005\n\u0005%\u0017!\u00034fi\u000eD7+\u001b>f+\t\tY\rE\u0002a\u0003\u001bL1!a4\u0017\u0005\rIe\u000e\u001e\u0005\t\u0003'\u0004\u0001\u0015!\u0003\u0002L\u0006Qa-\u001a;dQNK'0\u001a\u0011\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0017AD:j[BdWmQ8ogVlWM]\u000b\u0003\u00037\u00042!IAo\u0013\r\tyN\u0001\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011!\t\u0019\u000f\u0001Q\u0001\n\u0005m\u0017aD:j[BdWmQ8ogVlWM\u001d\u0011\t\u0013\u0005\u001d\bA1A\u0005\n\u0005%\u0018a\u00054fi\u000eD'+Z9vKN$()^5mI\u0016\u0014XCAAv!\r\u0011\u0018Q^\u0005\u0004\u0003_\u001c(a\u0005$fi\u000eD'+Z9vKN$()^5mI\u0016\u0014\b\u0002CAz\u0001\u0001\u0006I!a;\u0002)\u0019,Go\u00195SKF,Xm\u001d;Ck&dG-\u001a:!\u0011\u001d\t9\u0010\u0001C!\u0003s\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005=\u0001bBA\u007f\u0001\u0011\u0005\u0013q`\u0001\tg\",H\u000fZ8x]R\u0011!\u0011\u0001\t\u0004A\n\r\u0011b\u0001B\u0003-\t!QK\\5u\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017\tA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003\u0003B\u0001\u0005\u001b\u0011yAa\u0005\t\u000f\u0005u!q\u0001a\u0001o!A!\u0011\u0003B\u0004\u0001\u0004\t\u0019!A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\u0002\u0003B\u000b\u0005\u000f\u0001\r!!/\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\ta\u0003[1oI2,wJ\u001a4tKR|U\u000f^(g%\u0006tw-\u001a\u000b\u0005\u0003\u0007\u0011i\u0002C\u0004\u0002\u001e\t]\u0001\u0019A\u001c\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$\u0005Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR!!\u0011\u0001B\u0013\u0011!\u00119Ca\bA\u0002\t%\u0012A\u00039beRLG/[8ogB)\u00111\u0010B\u0016o%!!QFAE\u0005!IE/\u001a:bE2,\u0007b\u0002B\u0019\u0001\u0011E!1G\u0001\u0012EVLG\u000e\u001a$fi\u000eD'+Z9vKN$H\u0003\u0002B\u001b\u0005w\u0001B!\u001bB\u001c1&\u0019!\u0011H7\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0011\u001d\u0001$q\u0006a\u0001\u0005{\u0001RA\rB \u0005\u0007J1A!\u00114\u0005\r\u0019V-\u001d\t\u0007A\n\u0015sG!\u0013\n\u0007\t\u001dcC\u0001\u0004UkBdWM\r\t\u0004\u0013\t-\u0013b\u0001B'\u0015\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"9!\u0011\u000b\u0001\u0005\u0012\tM\u0013!\u00024fi\u000eDG\u0003\u0002B+\u00057\u0002b!a\u001f\u0003X\te\u0013\u0002\u0002B!\u0003\u0013\u0003b\u0001\u0019B#o\u0005e\u0006b\u0002B/\u0005\u001f\u0002\r\u0001W\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0005C\u0002A\u0011\tB2\u0003]\u0011W/\u001b7e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0003\u0003f\t%\u0004#B5\u00038\t\u001d\u0004#\u0002\u001a6o\u0005-\u0007\u0002\u0003B6\u0005?\u0002\rA!\u001c\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t!\u0019\tYHa\u0016\u0003D!9!\u0011\u000f\u0001\u0005B\tM\u0014!\u00064fi\u000eDW\t]8dQN4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0005k\u0012\u0019\tE\u00033k]\u00129\b\u0005\u0003\u0003z\t}TB\u0001B>\u0015\r\u0011i(O\u0001\te\u0016\fX/Z:ug&!!\u0011\u0011B>\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRD\u0001Ba\n\u0003p\u0001\u0007!q\r\u0005\b\u0005\u000f\u0003A\u0011\tBE\u00035i\u0017-\u001f2f)J,hnY1uKR!!1\u0012BG!\u0015I'qGA\u0001\u0011!\u0011yI!\"A\u0002\tU\u0014!\u00044fi\u000eDW\rZ#q_\u000eD7\u000fK\u0004\u0001\u0003?\u000by+!+")
public class ConsumerFetcherThread
extends AbstractFetcherThread {
    private final ConsumerConfig config;
    private final Map<TopicPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;
    private final String clientId;
    private final int fetchSize;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    private String clientId() {
        return this.clientId;
    }

    private int fetchSize() {
        return this.fetchSize;
    }

    private SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block0: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown || !this.isInterruptible()) break block0;
            this.simpleConsumer().disconnectToHandleJavaIOBug();
        }
        return (boolean)var1_1;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger((int)topicPartition.partition()), BoxesRunTime.boxToLong((long)pti.getFetchOffset()), BoxesRunTime.boxToLong((long)fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.underlying().messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        String string = this.config().autoOffsetReset();
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        long l = !(string2 != null ? !string2.equals(string3) : string3 != null) ? OffsetRequest$.MODULE$.EarliestTime() : OffsetRequest$.MODULE$.LatestTime();
        long startTimestamp = l;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply((Object)topicPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.removePartitions((Set<TopicPartition>)partitions.toSet());
            this.consumerFetcherManager().addPartitionsWithError(partitions);
        }
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            BoxedUnit boxedUnit = partitionFetchState.isReadyForFetch() ? this.fetchRequestBuilder().addFetch(topicPartition.topic(), topicPartition.partition(), partitionFetchState.fetchOffset(), this.fetchSize()) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(this.fetchRequestBuilder().build()), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        return (Seq)this.simpleConsumer().fetch(fetchRequest.underlying()).data().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FetchResponsePartitionData value;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    value = (FetchResponsePartitionData)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String t = topicAndPartition.topic();
            int p = topicAndPartition.partition();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(t, p)), (Object)new PartitionData(value));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        return new AbstractFetcherThread.ResultWithPartitions<GenMap>(Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        return new AbstractFetcherThread.ResultWithPartitions<GenMap>(Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    public ConsumerFetcherThread(String name, ConsumerConfig config, BrokerEndPoint sourceBroker, Map<TopicPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(name, config.clientId(), sourceBroker, config.refreshLeaderBackoffMs(), true, false);
        this.clientId = config.clientId();
        this.fetchSize = config.fetchMessageMaxBytes();
        this.simpleConsumer = new SimpleConsumer(super.sourceBroker().host(), super.sourceBroker().port(), config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(this.clientId()).replicaId(Request$.MODULE$.OrdinaryConsumerId()).maxWait(config.fetchWaitMaxMs()).minBytes(config.fetchMinBytes()).requestVersion((short)3);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private Map<TopicPartition, Object> tpToOffset;
        private final kafka.api.FetchRequest underlying;
        private volatile boolean bitmap$0;

        public kafka.api.FetchRequest underlying() {
            return this.underlying;
        }

        private Map<TopicPartition, Object> tpToOffset$lzycompute() {
            FetchRequest fetchRequest = this;
            synchronized (fetchRequest) {
                if (!this.bitmap$0) {
                    this.tpToOffset = ((TraversableOnce)this.underlying().requestInfo().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                        PartitionFetchInfo fetchInfo = (PartitionFetchInfo)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(tp.topic(), tp.partition())), (Object)BoxesRunTime.boxToLong((long)fetchInfo.offset()));
                        return tuple22;
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    this.bitmap$0 = true;
                }
            }
            return this.tpToOffset;
        }

        private Map<TopicPartition, Object> tpToOffset() {
            return !this.bitmap$0 ? this.tpToOffset$lzycompute() : this.tpToOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().requestInfo().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return BoxesRunTime.unboxToLong((Object)this.tpToOffset().apply((Object)topicPartition));
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(kafka.api.FetchRequest underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponsePartitionData underlying;

        public FetchResponsePartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error();
        }

        @Override
        public MemoryRecords toRecords() {
            return ((ByteBufferMessageSet)this.underlying().messages()).asRecords();
        }

        @Override
        public long highWatermark() {
            return this.underlying().hw();
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? None$.MODULE$ : new Some((Object)ErrorMapping$.MODULE$.exceptionFor(this.error().code()));
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponsePartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

