/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmd!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0007yI|w\u000e\u001e \n\u0003)I!!J\u0005\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0004'\u0016\f(BA\u0013\n!\tQs&D\u0001,\u0015\taS&\u0001\u0002j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u00111\u0015\u000e\\3\t\u0011I\u0002!\u0011!Q\u0001\nu\t\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!An\\4t+\u00051\u0004\u0003\u0002\b8s\u0011K!\u0001O\b\u0003\tA{w\u000e\u001c\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\naaY8n[>t'BA\u0003?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\r[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!k\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u0011Q\u0003!\u0011!Q\u0001\n5\u000bQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002F\u0001!)!$\u0016a\u0001;!)A'\u0016a\u0001m!)1*\u0016a\u0001\u001b\"9Q\f\u0001b\u0001\n\u0003r\u0016A\u00037pO\u001e,'OT1nKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c[\u0005!A.\u00198h\u0013\t!\u0017M\u0001\u0004TiJLgn\u001a\u0005\u0007M\u0002\u0001\u000b\u0011B0\u0002\u00171|wmZ3s\u001d\u0006lW\r\t\u0005\tQ\u0002\u0011\r\u0011\"\u0001\u0003=\u0006!rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016DaA\u001b\u0001!\u0002\u0013y\u0016!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\r\t\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u0016\u00039\u0004Ba\u001c;*m6\t\u0001O\u0003\u0002re\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003g&\t!bY8mY\u0016\u001cG/[8o\u0013\t)\bOA\u0002NCB\u0004\"a^=\u000e\u0003aT!\u0001\\(\n\u0005iD(\u0001F(gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rC\u0004}\u0001\u0001\u0007I\u0011B?\u0002\u001f\rDWmY6q_&tGo]0%KF$2A`A\u0002!\tAq0C\u0002\u0002\u0002%\u0011A!\u00168ji\"A\u0011QA>\u0002\u0002\u0003\u0007a.A\u0002yIEBq!!\u0003\u0001A\u0003&a.\u0001\u0007dQ\u0016\u001c7\u000e]8j]R\u001c\b\u0005\u000b\u0003\u0002\b\u00055\u0001c\u0001\u0005\u0002\u0010%\u0019\u0011\u0011C\u0005\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\u0002\u0015%t\u0007K]8he\u0016\u001c8/\u0006\u0002\u0002\u001aA9\u00111DA\u0011s\u0005\u0015RBAA\u000f\u0015\r\tyB]\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\u0019#!\b\u0003\u000f!\u000b7\u000f['baB\u0019Q)a\n\n\u0007\u0005%\"A\u0001\tM_\u001e\u001cE.Z1oS:<7\u000b^1uK\"A\u0011Q\u0006\u0001!\u0002\u0013\tI\"A\u0006j]B\u0013xn\u001a:fgN\u0004\u0003\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0003\u0011awnY6\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u007f\t\t%\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u0011.\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0013\u0011\b\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u0011\u0005-\u0003\u0001)A\u0005\u0003k\tQ\u0001\\8dW\u0002B\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\u0002%A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000eZ\u000b\u0003\u0003'\u0002B!a\u000e\u0002V%!\u0011qKA\u001d\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA*\u0003M\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3!\u0011%\ty\u0006\u0001a\u0001\n\u0013\t\t'A\reSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|WCAA2!\rA\u0011QM\u0005\u0004\u0003OJ!A\u0002#pk\ndW\rC\u0005\u0002l\u0001\u0001\r\u0011\"\u0003\u0002n\u0005iB-\u001b:uS\u0016\u001cH\u000fT8h\u00072,\u0017M\\1cY\u0016\u0014\u0016\r^5p?\u0012*\u0017\u000fF\u0002\u007f\u0003_B!\"!\u0002\u0002j\u0005\u0005\t\u0019AA2\u0011!\t\u0019\b\u0001Q!\n\u0005\r\u0014A\u00073jeRLWm\u001d;M_\u001e\u001cE.Z1oC\ndWMU1uS>\u0004\u0003\u0006BA9\u0003\u001bA\u0011\"!\u001f\u0001\u0001\u0004%I!a\u001f\u0002\u001bQLW.Z(g\u0019\u0006\u001cHOU;o+\t\ti\bE\u0002\t\u0003\u007fJ1!!!\n\u0005\u0011auN\\4\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0015!\u0005;j[\u0016|e\rT1tiJ+hn\u0018\u0013fcR\u0019a0!#\t\u0015\u0005\u0015\u00111QA\u0001\u0002\u0004\ti\b\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA?\u00039!\u0018.\\3PM2\u000b7\u000f\u001e*v]\u0002BC!a#\u0002\u000e!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015!F1mY\u000ecW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0003/\u0003r!!'\u0002\"f\niH\u0004\u0003\u0002\u001c\u0006u\u0005C\u0001\u0011\n\u0013\r\ty*C\u0001\u0007!J,G-\u001a4\n\u0007U\f\u0019KC\u0002\u0002 &Aq!a*\u0001\t\u0003\tI+A\rhe\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><G\u0003BAV\u0003o\u0003R\u0001CAW\u0003cK1!a,\n\u0005\u0019y\u0005\u000f^5p]B\u0019Q)a-\n\u0007\u0005U&A\u0001\u0006M_\u001e$vn\u00117fC:D\u0001\"!/\u0002&\u0002\u0007\u00111X\u0001\u0005i&lW\r\u0005\u0003\u0002>\u0006\u0005WBAA`\u0015\t\u00012(\u0003\u0003\u0002D\u0006}&\u0001\u0002+j[\u0016Dq!a2\u0001\t\u0003\tI-A\u0007eK2,G/\u00192mK2{wm\u001d\u000b\u0003\u0003\u0017\u0004RAHAg\u0003#L1!a4)\u0005!IE/\u001a:bE2,\u0007#\u0002\u0005\u0002Tf\"\u0015bAAk\u0013\t1A+\u001e9mKJBq!!7\u0001\t\u0003\tY.A\u0007bE>\u0014Ho\u00117fC:Lgn\u001a\u000b\u0004}\u0006u\u0007bBAp\u0003/\u0004\r!O\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003K\fQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\rF\u0002\u007f\u0003ODq!a8\u0002b\u0002\u0007\u0011\bC\u0004\u0002l\u0002!\t!!<\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR\u0019a0a<\t\u000f\u0005}\u0017\u0011\u001ea\u0001s!9\u00111\u001f\u0001\u0005\n\u0005U\u0018!E5t\u00072,\u0017M\\5oO&s7\u000b^1uKR1\u0011q_A\u007f\u0003\u007f\u00042\u0001CA}\u0013\r\tY0\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\ty.!=A\u0002eB\u0001B!\u0001\u0002r\u0002\u0007\u0011QE\u0001\u000eKb\u0004Xm\u0019;fIN#\u0018\r^3\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b\u0005!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$2A B\u0005\u0011\u001d\tyNa\u0001A\u0002eBqA!\u0004\u0001\t\u0003\u0011y!A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$RA B\t\u0005+AqAa\u0005\u0003\f\u0001\u0007\u0011&A\u0004eCR\fG)\u001b:\t\u0011\t]!1\u0002a\u0001\u00053\ta!\u001e9eCR,\u0007#\u0002\u0005\u0002.\nm\u0001C\u0002\u0005\u0002Tf\ni\bC\u0004\u0003 \u0001!\tA!\t\u0002'!\fg\u000e\u001a7f\u0019><G)\u001b:GC&dWO]3\u0015\u0007y\u0014\u0019\u0003\u0003\u0005\u0003&\tu\u0001\u0019\u0001B\u0014\u0003\r!\u0017N\u001d\t\u0005\u00033\u0013I#C\u0002e\u0003GCqA!\f\u0001\t\u0003\u0011y#A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiR9aP!\r\u00034\tU\u0002b\u0002B\n\u0005W\u0001\r!\u000b\u0005\b\u0003?\u0014Y\u00031\u0001:\u0011!\u00119Da\u000bA\u0002\u0005u\u0014AB8gMN,G\u000fC\u0004\u0003<\u0001!\tA!\u0010\u0002\u0019\u0011|g.Z\"mK\u0006t\u0017N\\4\u0015\u000fy\u0014yD!\u0011\u0003D!9\u0011q\u001cB\u001d\u0001\u0004I\u0004b\u0002B\n\u0005s\u0001\r!\u000b\u0005\t\u0005\u000b\u0012I\u00041\u0001\u0002~\u0005IQM\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u00031!wN\\3EK2,G/\u001b8h)\rq(Q\n\u0005\b\u0003?\u00149\u00051\u0001:\u000f!\u0011\tF\u0001E\u0001\u0005\tM\u0013!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4feB\u0019QI!\u0016\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003XM!!QK\u0004\u000e\u0011\u001d1&Q\u000bC\u0001\u00057\"\"Aa\u0015\t\u0011\t}#Q\u000bC\u0001\u0005C\n!#[:D_6\u0004\u0018m\u0019;B]\u0012$U\r\\3uKR!\u0011q\u001fB2\u0011\u0019\u0019!Q\fa\u0001\t\"A!q\rB+\t\u0003\u0011I'\u0001\tdY\u0016\fg.\u00192mK>3gm]3ugRQ!1\u000eB7\u0005_\u0012\tHa\u001e\u0011\u000f!\t\u0019.! \u0002~!11A!\u001aA\u0002\u0011Cq!a8\u0003f\u0001\u0007\u0011\b\u0003\u0005\u0003t\t\u0015\u0004\u0019\u0001B;\u0003%a\u0017m\u001d;DY\u0016\fg\u000eE\u0003pif\ni\b\u0003\u0005\u0003z\t\u0015\u0004\u0019AA?\u0003\rqwn\u001e")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            scala.collection.immutable.Map map;
            try {
                map = checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpoint.file().getName(), checkpoint.file().getParentFile().getAbsolutePath()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$4)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning(topicPartition);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                option = this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                Option option3 = this.inProgress().put((Object)topicPartition, (Object)LogCleaningAborted$.MODULE$);
                option = option3;
            } else {
                throw new MatchError((Object)option2);
            }
            while (!this.isCleaningInState(topicPartition, LogCleaningPaused$.MODULE$)) {
                this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                option = this.inProgress().remove((Object)topicPartition);
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = option;
            return option3;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint == null) break block2;
                try {
                    Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
                    checkpoint.write((Map<TopicPartition, Object>)existing);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpoint.file().getName(), checkpoint.file().getParentFile().getAbsolutePath()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping cleaning logs in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir})));
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.checkpoints().filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x$2)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (!this.logs().get(topicPartition).config().compact() || (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)) == null || BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            LogCleaningState logCleaningState = (LogCleaningState)this.inProgress().apply((Object)topicPartition);
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                option = this.inProgress().remove((Object)topicPartition);
            } else if (LogCleaningAborted$.MODULE$.equals(logCleaningState)) {
                this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                option = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
            }
            return option;
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().remove((Object)topicPartition));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$1, File x$2) {
        String string = x$2.getAbsolutePath();
        String string2 = dir$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

