/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0005\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002Bqa\u0016\u0001C\u0002\u0013%\u0001,A\tde\u0016\fG/\u001a+pa&\u001c\u0007k\u001c7jGf,\u0012!\u0017\t\u0004\u0013ic\u0016BA.\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q,Y\u0007\u0002=*\u0011q\fY\u0001\u0007a>d\u0017nY=\u000b\u0005\rQ\u0013B\u00012_\u0005E\u0019%/Z1uKR{\u0007/[2Q_2L7-\u001f\u0005\u0007I\u0002\u0001\u000b\u0011B-\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010\t\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0002QB\u0019\u0011BW5\u0011\u0005uS\u0017BA6_\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0005\u0007[\u0002\u0001\u000b\u0011\u00025\u0002%\u0005dG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\t\u0005\u0006_\u0002!\t\u0001]\u0001\u001aQ\u0006\u001cH)\u001a7bs\u0016$Gk\u001c9jG>\u0003XM]1uS>t7/F\u0001r!\tI!/\u0003\u0002t\u0015\t9!i\\8mK\u0006t\u0007\"B;\u0001\t\u00031\u0018!\t;ss\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012$v\u000e]5d\u001fB,'/\u0019;j_:\u001cHCA<{!\tI\u00010\u0003\u0002z\u0015\t!QK\\5u\u0011\u0015YH\u000f1\u0001}\u0003\u0015!x\u000e]5d!\ri\u0018\u0011\u0002\b\u0004}\u0006\u0015\u0001CA@\u000b\u001b\t\t\tAC\u0002\u0002\u0004\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u0004\u0015\u00051\u0001K]3eK\u001aLA!a\u0003\u0002\u000e\t11\u000b\u001e:j]\u001eT1!a\u0002\u000b\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tAb\u0019:fCR,Gk\u001c9jGN$\u0012b^A\u000b\u0003?\t\u0019#!\u0017\t\u0011\u0005]\u0011q\u0002a\u0001\u00033\tq\u0001^5nK>,H\u000fE\u0002\n\u00037I1!!\b\u000b\u0005\rIe\u000e\u001e\u0005\b\u0003C\ty\u00011\u0001r\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011!\t)#a\u0004A\u0002\u0005\u001d\u0012AC2sK\u0006$X-\u00138g_B9\u0011\u0011FA\u0018y\u0006MRBAA\u0016\u0015\r\tiCC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0019\u0003W\u00111!T1q!\u0011\t)$a\u0015\u000f\t\u0005]\u0012Q\n\b\u0005\u0003s\tIE\u0004\u0003\u0002<\u0005\u001dc\u0002BA\u001f\u0003\u000brA!a\u0010\u0002D9\u0019q0!\u0011\n\u00039J!\u0001L\u0017\n\u0005\u0015Y\u0013BA\u0015+\u0013\r\tY\u0005K\u0001\te\u0016\fX/Z:ug&!\u0011qJA)\u0003M\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\u0015\r\tY\u0005K\u0005\u0005\u0003+\n9F\u0001\u0007U_BL7\rR3uC&d7O\u0003\u0003\u0002P\u0005E\u0003\u0002CA.\u0003\u001f\u0001\r!!\u0018\u0002!I,7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007CB\u0005\u0002`\u0005\rt/C\u0002\u0002b)\u0011\u0011BR;oGRLwN\\\u0019\u0011\u000f\u0005%\u0012q\u0006?\u0002fA!\u0011qMA5\u001b\t\t\t&\u0003\u0003\u0002l\u0005E#\u0001C!qS\u0016\u0013(o\u001c:\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005aA-\u001a7fi\u0016$v\u000e]5dgR9q/a\u001d\u0002v\u0005}\u0004\u0002CA\f\u0003[\u0002\r!!\u0007\t\u0011\u0005]\u0014Q\u000ea\u0001\u0003s\na\u0001^8qS\u000e\u001c\b#BA\u0015\u0003wb\u0018\u0002BA?\u0003W\u00111aU3u\u0011!\tY&!\u001cA\u0002\u0005\u0005\u0005CB\u0005\u0002`\u0005\ru\u000fE\u0004\u0002*\u0005=B0!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#)\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAH\u0003\u0013\u0013a!\u0012:s_J\u001c\bbBAJ\u0001\u0011\u0005\u0011QS\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N$2b^AL\u00033\u000by+!-\u0002B\"A\u0011qCAI\u0001\u0004\tI\u0002\u0003\u0005\u0002\u001c\u0006E\u0005\u0019AAO\u00035qWm\u001e)beRLG/[8ogB9\u0011\u0011FA\u0018y\u0006}\u0005\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003SS\u0013aB2mS\u0016tGo]\u0005\u0005\u0003[\u000b\u0019KA\u0007OK^\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003C\t\t\n1\u0001r\u0011!\t\u0019,!%A\u0002\u0005U\u0016\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m\u0006&A\u0004oKR<xN]6\n\t\u0005}\u0016\u0011\u0018\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\t\u0003\u0007\f\t\n1\u0001\u0002^\u0005A1-\u00197mE\u0006\u001c7\u000eC\u0004\u0002H\u0002!\t!!3\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$B!a3\u0002bBA\u0011\u0011FA\u0018\u0003\u001b\f\u0019\u000e\u0005\u0003\u0002h\u0005=\u0017\u0002BAi\u0003#\u0012\u0001BU3t_V\u00148-\u001a\t\u0005\u0003+\fYN\u0004\u0003\u0002h\u0005]\u0017\u0002BAm\u0003#\nq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\u0005u\u0017q\u001c\u0002\u0007\u0007>tg-[4\u000b\t\u0005e\u0017\u0011\u000b\u0005\t\u0003G\f)\r1\u0001\u0002f\u0006)\"/Z:pkJ\u001cW\rV8D_:4\u0017n\u001a(b[\u0016\u001c\b\u0003CA\u0015\u0003_\ti-a:\u0011\t%Q\u0016\u0011\u0010\u0005\b\u0003W\u0004A\u0011AAw\u00031\tG\u000e^3s\u0007>tg-[4t)\u0019\ty/!=\u0003\u0004AA\u0011\u0011FA\u0018\u0003\u001b\f)\u0007\u0003\u0005\u0002t\u0006%\b\u0019AA{\u0003\u001d\u0019wN\u001c4jON\u0004\u0002\"!\u000b\u00020\u00055\u0017q\u001f\t\u0005\u0003s\fyP\u0004\u0003\u0002h\u0005m\u0018\u0002BA\u007f\u0003#\n1#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgRLA!!8\u0003\u0002)!\u0011Q`A)\u0011\u001d\t\t#!;A\u0002EDqAa\u0002\u0001\t\u0003\u0011I!\u0001\u0005tQV$Hm\\<o)\u00059\b")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key.keyLabel(), BoxesRunTime.boxToInteger((int)completed)})));
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        List replicas = (List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, assignments})));
                    Option<CreateTopicPolicy> option = this.createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                        AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.zkUtils(), topic, assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (!validateOnly) {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (validateOnly) {
                            AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else {
                        throw new MatchError(option);
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, assignments, ApiError.NONE);
                }
                catch (Throwable throwable) {
                    CreatePartitionsMetadata createPartitionsMetadata2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof PolicyViolationException ? true : throwable2 instanceof ApiException;
                    if (bl) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, arguments})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                        createPartitionsMetadata2 = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable2));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, arguments})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        createPartitionsMetadata2 = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        throw throwable;
                    }
                    createPartitionsMetadata = createPartitionsMetadata2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata3 = createPartitionsMetadata;
            return createPartitionsMetadata3;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$11(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), (String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void createPartitions(int timeout, Map<String, NewPartitions> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
        Seq<BrokerMetadata> allBrokers = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                NewPartitions newPartition = (NewPartitions)tuple2._2();
                try {
                    if (reassignPartitionsInProgress) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.mutable.Map existingAssignment = (scala.collection.mutable.Map)this.zkUtils().getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic currently has ", " partitions, which is higher than the requested ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions), BoxesRunTime.boxToInteger((int)newNumPartitions)})));
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic already has ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumPartitions)})));
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.assignments()).map((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)assignments -> {
                        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds);
                        if (unknownBrokers.nonEmpty()) {
                            throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown broker(s) in replica assignment: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unknownBrokers.mkString(", ")})));
                        }
                        if (assignments.size() != numPartitionsIncrement) {
                            throw new InvalidReplicaAssignmentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Increasing the number of partitions by ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitionsIncrement)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " assignments provided."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)assignments.size())})));
                        }
                        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                            Tuple2 tuple2 = x0$6;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Buffer replicas = (Buffer)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment.size() + index))), (Object)replicas);
                            return tuple22;
                        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, validateOnly);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                }
                catch (AdminOperationException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
                catch (ApiException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$9(x$10)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> createPartitionMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1 & Serializable & scala.Serializable)x$11 -> new TopicKey((String)x$11), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public Map<Resource, DescribeConfigsResponse.Config> describeConfigs(Map<Resource, Option<Set<String>>> resourceToConfigNames) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                Resource resource = (Resource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ResourceType resourceType = resource.type();
                    if (ResourceType.TOPIC.equals(resourceType)) {
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        Properties topicProps = AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
                        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                        config = AdminManager.createResponseConfig$1(logConfig, false, (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$6(topicProps, name)), configNames);
                    } else if (ResourceType.BROKER.equals(resourceType)) {
                        int brokerId = AdminManager.liftedTree1$1(resource);
                        if (brokerId != this.config().brokerId()) {
                            throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", ", but received ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), BoxesRunTime.boxToInteger((int)brokerId)})));
                        }
                        config = AdminManager.createResponseConfig$1(this.config(), true, (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$7(this, name)), configNames);
                    } else {
                        throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported resource type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceType})));
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                }
                catch (Throwable e) {
                    String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing describe configs request for resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource}));
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList()));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<Resource, ApiError> alterConfigs(Map<Resource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$10;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Resource resource = (Resource)tuple22._1();
            AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
            try {
                ResourceType resourceType = resource.type();
                if (!ResourceType.TOPIC.equals(resourceType)) throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AlterConfigs is only supported for topics, but resource type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceType})));
                String topic = resource.name();
                Properties properties = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> properties.setProperty(configEntry.name(), configEntry.value()));
                Option<AlterConfigPolicy> option = this.alterConfigPolicy();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
                    AdminUtils$.MODULE$.validateTopicConfig(this.zkUtils(), topic, properties);
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(ConfigResource.Type.TOPIC, resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
                    if (!validateOnly) {
                        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), topic, properties);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit;
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    if (validateOnly) {
                        AdminUtils$.MODULE$.validateTopicConfig(this.zkUtils(), topic, properties);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        AdminUtils$.MODULE$.changeTopicConfig(this.zkUtils(), topic, properties);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                tuple2 = tuple23;
                return tuple2;
            }
            catch (ConfigException e) {
                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for resource ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, e.getMessage()}));
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, (Throwable)e)));
                return tuple2;
            }
            catch (Throwable e) {
                String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing alter configs request for resource ", ", config ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource, config}));
                if (e instanceof ApiException || e instanceof PolicyViolationException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)e));
            }
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        }));
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$11(CreatePartitionsMetadata x$2) {
        return x$2.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$9(CreatePartitionsMetadata x$10) {
        return x$10.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Option configNames$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String configName = (String)tuple2._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)configNames$1.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains((Object)configName))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(AbstractConfig config, boolean isReadOnly, Function1 isDefault, Option configNames$1) {
        IndexedSeq filteredConfigPairs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(configNames$1, x0$8)))).toIndexedSeq();
        IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            ConfigDef.Type configEntryType;
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            ConfigDef.Type type = configEntryType = config.typeOf(name);
            ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
            boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
            String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
            DescribeConfigsResponse.ConfigEntry configEntry = new DescribeConfigsResponse.ConfigEntry(name, valueAsString, isSensitive, BoxesRunTime.unboxToBoolean((Object)isDefault.apply((Object)name)), isReadOnly);
            return configEntry;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$6(Properties topicProps$1, String name) {
        return !topicProps$1.containsKey(name);
    }

    private static final int liftedTree1$1(Resource resource$1) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(resource$1.name())).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id must be an integer, but it is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource$1.name()})));
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$7(AdminManager $this, String name) {
        return !$this.config().originals().containsKey(name);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[Admin Manager on Broker " + config.brokerId() + "]: ");
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

