/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b}3\u0017\u000e\\3\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012AA5p\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\t\u0019KG.\u001a\u0005\nA\u0001\u0011\t\u0011)A\u0005\u0019\u0005\n!BY1tK>3gm]3u\u0013\t\u0001#\u0002C\u0005$\u0001\t\u0005\t\u0015!\u0003\u0013I\u0005aQ.\u0019=J]\u0012,\u0007pU5{K&\u00111E\u0003\u0005\nM\u0001\u0011\t\u0011)A\u0005O)\n\u0001b\u001e:ji\u0006\u0014G.\u001a\t\u0003\u001b!J!!\u000b\b\u0003\u000f\t{w\u000e\\3b]&\u0011aE\u0003\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9z\u0003'\r\u001a\u0011\u0005%\u0001\u0001\"\u0002\f,\u0001\u00049\u0002\"\u0002\u0011,\u0001\u0004a\u0001bB\u0012,!\u0003\u0005\rA\u0005\u0005\bM-\u0002\n\u00111\u0001(\u0011\u0015!\u0004\u0001\"\u00116\u0003%)g\u000e\u001e:z'&TX-F\u0001\u0013\u0011\u00199\u0004\u0001)Q\u0005\u0019\u0005Yq\f\\1ti>3gm]3u\u0011\u0015I\u0004\u0001\"\u0003;\u0003%a\u0017m\u001d;F]R\u0014\u00180F\u0001<!\tIA(\u0003\u0002>\u0005\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007\"B \u0001\t\u0003\u0001\u0015A\u00037bgR|eMZ:fiV\tA\u0002C\u0003C\u0001\u0011\u00051)\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003w\u0011CQ!R!A\u00021\tA\u0002^1sO\u0016$xJ\u001a4tKRDQa\u0012\u0001\u0005\u0002!\u000bQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000fF\u0002J\u0019:\u00032!\u0004&<\u0013\tYeB\u0001\u0004PaRLwN\u001c\u0005\u0006\u001b\u001a\u0003\raO\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0003P\r\u0002\u0007!#A\u0005gKR\u001c\u0007nU5{K\")\u0011\u000b\u0001C\u0005%\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$Hc\u0001\nT7\")A\u000b\u0015a\u0001+\u00061!-\u001e4gKJ\u0004\"AV-\u000e\u0003]S!\u0001W\u000e\u0002\u00079Lw.\u0003\u0002[/\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bq\u0003\u0006\u0019\u0001\n\u0002\u00039DQA\u0018\u0001\u0005\n}\u000b\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u000b\u0004%\u0001\f\u0007\"\u0002+^\u0001\u0004)\u0006\"\u0002/^\u0001\u0004\u0011\u0002\"B2\u0001\t\u0003\"\u0017A\u00039beN,WI\u001c;ssR\u0019Q\r[5\u0011\u0005%1\u0017BA4\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\u0006)\n\u0004\r!\u0016\u0005\u00069\n\u0004\rA\u0005\u0005\u0006W\u0002!\t\u0001\\\u0001\u0006K:$(/\u001f\u000b\u0003w5DQ\u0001\u00186A\u0002IAQa\u001c\u0001\u0005\u0002A\fa!\u00199qK:$GcA9umB\u0011QB]\u0005\u0003g:\u0011A!\u00168ji\")QO\u001ca\u0001\u0019\u00051qN\u001a4tKRDQa\u001e8A\u0002I\t\u0001\u0002]8tSRLwN\u001c\u0005\u0006s\u0002!\tE_\u0001\tiJ,hnY1uKR\t\u0011\u000fC\u0003}\u0001\u0011\u0005S0\u0001\u0006ueVt7-\u0019;f)>$\"!\u001d@\t\u000bU\\\b\u0019\u0001\u0007\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0007E\f)\u0001\u0003\u0004\u0002\b}\u0004\rAE\u0001\bK:$(/[3t\u0011\u0019\tY\u0001\u0001C!u\u0006Y1/\u00198jif\u001c\u0005.Z2l\u00111\ty\u0001\u0001I\u0001\u0004\u0003\u0005I\u0011B\u001b%\u0003I\u0019X\u000f]3sI5\f\u00070\u00138eKb\u001c\u0016N_3\t\u0019\u0005M\u0001\u0001%A\u0002\u0002\u0003%I\u0001Q\u0011\u0002!M,\b/\u001a:%E\u0006\u001cXm\u00144gg\u0016$x!CA\f\u0005\u0005\u0005\t\u0012AA\r\u0003-yeMZ:fi&sG-\u001a=\u0011\u0007%\tYB\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u000f'\u0011\tY\"a\b\u0011\u00075\t\t#C\u0002\u0002$9\u0011a!\u00118z%\u00164\u0007b\u0002\u0017\u0002\u001c\u0011\u0005\u0011q\u0005\u000b\u0003\u00033A!\"a\u000b\u0002\u001cE\u0005I\u0011AA\u0017\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0006\u0016\u0004%\u0005E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ub\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0015\u00131DI\u0001\n\u0003\t9%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013R3aJA\u0019\u0001")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    private long _lastOffset = this.lastEntry().offset();

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetPosition offsetPosition;
            int n = this._entries();
            switch (n) {
                case 0: {
                    offsetPosition = new OffsetPosition(this.super$baseOffset(), 0);
                    break;
                }
                default: {
                    offsetPosition = (OffsetPosition)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return offsetPosition;
        });
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new OffsetPosition(this.super$baseOffset(), 0) : (OffsetPosition)this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$.MODULE$.VALUE());
            return slot == -1 ? None$.MODULE$ : new Some((Object)((OffsetPosition)this.parseEntry(idx, slot)));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new OffsetPosition(this.relativeOffset(idx, n), this.physical(idx, n));
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> "Attempt to append to a full index (size = " + this._entries() + ").");
            if (this._entries() != 0 && offset <= $this._lastOffset) {
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this.entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), this.file().getAbsolutePath()})));
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)position), this.file().getName()})));
            this.mmap().putInt((int)(offset - this.super$baseOffset()));
            this.mmap().putInt(position);
            this._entries_$eq(this._entries() + 1);
            $this._lastOffset = offset;
            Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> this.entries() + " entries but file position in index is " + this.mmap().position() + ".");
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.KEY());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            $this._lastOffset = this.lastEntry().offset();
        });
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this._lastOffset <= super.baseOffset()) {
            throw new CorruptIndexException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the last offset is ", " which is no greater than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this._lastOffset), BoxesRunTime.boxToLong((long)super.baseOffset())})));
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index file ", " is corrupt, found ", " bytes which is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.length())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"neither positive nor a multiple of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.entrySize())})));
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.maxEntries()), BoxesRunTime.boxToInteger((int)this.super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)$this._lastOffset), BoxesRunTime.boxToInteger((int)this.mmap().position())})));
    }
}

