/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.server.KafkaServer;
import kafka.server.KafkaServerStartable;
import kafka.server.KafkaServerStartable$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LoggingSignalHandler;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class Kafka$
implements Logging {
    public static Kafka$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Kafka$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Kafka$ kafka$ = this;
        synchronized (kafka$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Properties getPropsFromArgs(String[] args) {
        Properties props;
        block3: {
            OptionParser optionParser = new OptionParser(false);
            ArgumentAcceptingOptionSpec overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
            OptionSpecBuilder versionOpt = optionParser.accepts("version", "Print version information and exit.");
            if (args.length == 0 || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).contains((Object)"--help")) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringOps(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaServer.class.getSimpleName()})));
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).contains((Object)"--version")) {
                throw CommandLineUtils$.MODULE$.printVersionAndDie();
            }
            props = Utils.loadProps((String)args[0]);
            if (args.length <= 1) break block3;
            OptionSet options = optionParser.parse((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringBuilder(31).append("Found non argument parameters: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(options.nonOptionArguments().toArray())).mkString(",")).toString());
            }
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)overrideOpt)).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2()));
        }
        return props;
    }

    public void main(String[] args) {
        try {
            Properties serverProps = this.getPropsFromArgs(args);
            KafkaServerStartable kafkaServerStartable = KafkaServerStartable$.MODULE$.fromProps(serverProps);
            try {
                if (!OperatingSystem.IS_WINDOWS && !Java.isIbmJdk()) {
                    new LoggingSignalHandler().register();
                }
            }
            catch (ReflectiveOperationException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Failed to register optional signal handler that logs a message when the process is terminated ").append(new StringBuilder(49).append("by a signal. Reason for registration failure is: ").append(e).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(kafkaServerStartable){
                private final KafkaServerStartable kafkaServerStartable$1;

                public void run() {
                    this.kafkaServerStartable$1.shutdown();
                }
                {
                    this.kafkaServerStartable$1 = kafkaServerStartable$1;
                    super("kafka-shutdown-hook");
                }
            });
            kafkaServerStartable.startup();
            kafkaServerStartable.awaitShutdown();
        }
        catch (Throwable e) {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exiting Kafka due to fatal exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private Kafka$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

