/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;

class ResolutionManagementInfo {
    private boolean resolutionRequired;
    private final ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter();
    private boolean resolvedTransitively;
    private final Set<MavenProject> enabledProjects = new LinkedHashSet<MavenProject>();
    private final LinkedHashSet<Artifact> artifacts = new LinkedHashSet();

    ResolutionManagementInfo(MavenProject currentProject) {
        this.enabledProjects.add(currentProject);
    }

    boolean isResolutionRequired() {
        return this.resolutionRequired;
    }

    void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    boolean isResolvedTransitively() {
        return this.resolvedTransitively;
    }

    void setResolvedTransitively(boolean resolvedTransitively) {
        this.resolvedTransitively = this.resolvedTransitively || resolvedTransitively;
    }

    ScopeArtifactFilter getScopeFilter() {
        return this.scopeFilter;
    }

    void enableCompileScope() {
        this.scopeFilter.setIncludeCompileScope(true);
        this.scopeFilter.setIncludeProvidedScope(true);
        this.scopeFilter.setIncludeSystemScope(true);
    }

    void enableProvidedScope() {
        this.scopeFilter.setIncludeProvidedScope(true);
    }

    void enableRuntimeScope() {
        this.scopeFilter.setIncludeRuntimeScope(true);
        this.scopeFilter.setIncludeCompileScope(true);
    }

    void enableTestScope() {
        this.scopeFilter.setIncludeTestScope(true);
        this.scopeFilter.setIncludeCompileScope(true);
        this.scopeFilter.setIncludeProvidedScope(true);
        this.scopeFilter.setIncludeSystemScope(true);
        this.scopeFilter.setIncludeRuntimeScope(true);
    }

    void enableSystemScope() {
        this.scopeFilter.setIncludeSystemScope(true);
    }

    void enableProjectResolution(MavenProject project) {
        if (!this.enabledProjects.contains(project)) {
            this.enabledProjects.add(project);
        }
    }

    Set<MavenProject> getEnabledProjects() {
        return this.enabledProjects;
    }

    Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    void addArtifacts(Set<Artifact> a) {
        for (Artifact artifact : a) {
            this.addOneArtifact(artifact);
        }
        this.artifacts.addAll(a);
    }

    private void addOneArtifact(Artifact artifact) {
        for (Artifact existing : this.artifacts) {
            if (!existing.equals(artifact) || !this.isScopeUpgrade(artifact, existing)) continue;
            this.artifacts.remove(existing);
            this.artifacts.add(artifact);
            return;
        }
    }

    private boolean isScopeUpgrade(Artifact a, Artifact existing) {
        return this.scopeValue(a.getScope()) > this.scopeValue(existing.getScope());
    }

    private int scopeValue(String scope) {
        if ("compile".equals(scope)) {
            return 5;
        }
        if ("provided".equals(scope)) {
            return 4;
        }
        if ("runtime".equals(scope)) {
            return 3;
        }
        if ("system".equals(scope)) {
            return 2;
        }
        if ("test".equals(scope)) {
            return 1;
        }
        return 0;
    }
}

