/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.rs;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;

public abstract class ResourceServer {
    protected Map<ParameterStyle, Class> extractors = new HashMap<ParameterStyle, Class>();
    protected Map<ParameterStyle, Class> validators = new HashMap<ParameterStyle, Class>();

    public OAuthValidator instantiateValidator(ParameterStyle ps) throws OAuthSystemException {
        Class clazz = this.validators.get(ps);
        if (clazz == null) {
            throw new OAuthSystemException("Cannot instantiate a message validator.");
        }
        return (OAuthValidator)OAuthUtils.instantiateClass((Class)clazz);
    }

    public TokenExtractor instantiateExtractor(ParameterStyle ps) throws OAuthSystemException {
        Class clazz = this.extractors.get(ps);
        if (clazz == null) {
            throw new OAuthSystemException("Cannot instantiate a token extractor.");
        }
        return (TokenExtractor)OAuthUtils.instantiateClass((Class)clazz);
    }

    public static String[] getQueryParameterValues(HttpServletRequest request, String name) {
        String[] params;
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String param : params = query.split("&")) {
            try {
                param = URLDecoder.decode(param, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            int index = param.indexOf(61);
            String key = param;
            String value = null;
            if (index != -1) {
                key = param.substring(0, index);
                value = param.substring(index + 1);
            }
            if (!key.equals(name)) continue;
            values.add(value);
        }
        return values.toArray(new String[values.size()]);
    }

    public static String getQueryParameterValue(HttpServletRequest request, String name) {
        String[] values = ResourceServer.getQueryParameterValues(request, name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }
}

