/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.rs.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.common.message.types.TokenType;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.apache.oltu.oauth2.rs.BearerResourceServer;
import org.apache.oltu.oauth2.rs.ResourceServer;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;

public class OAuthAccessResourceRequest {
    private HttpServletRequest request;
    private ParameterStyle[] parameterStyles = new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE};
    private TokenType[] tokenTypes = new TokenType[]{OAuth.DEFAULT_TOKEN_TYPE};
    private ParameterStyle usedParameterStyle;
    private ResourceServer usedResourceServer;
    protected static Map<TokenType, Class> tokens = new HashMap<TokenType, Class>();
    private TokenExtractor extractor;

    public OAuthAccessResourceRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        this(request, new TokenType[]{OAuth.DEFAULT_TOKEN_TYPE}, new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE});
    }

    public OAuthAccessResourceRequest(HttpServletRequest request, ParameterStyle ... parameterStyles) throws OAuthSystemException, OAuthProblemException {
        this(request, new TokenType[]{OAuth.DEFAULT_TOKEN_TYPE}, parameterStyles);
    }

    public OAuthAccessResourceRequest(HttpServletRequest request, TokenType ... tokenTypes) throws OAuthSystemException, OAuthProblemException {
        this(request, tokenTypes, new ParameterStyle[]{OAuth.DEFAULT_PARAMETER_STYLE});
    }

    public OAuthAccessResourceRequest(HttpServletRequest request, TokenType[] tokenTypes, ParameterStyle[] parameterStyles) throws OAuthSystemException, OAuthProblemException {
        tokens.put(TokenType.BEARER, BearerResourceServer.class);
        this.request = request;
        this.tokenTypes = tokenTypes;
        this.parameterStyles = parameterStyles;
        this.validate();
    }

    public String getAccessToken() throws OAuthSystemException {
        return this.extractor.getAccessToken(this.request);
    }

    private void validate() throws OAuthSystemException, OAuthProblemException {
        int foundValidStyles = 0;
        boolean lackAuthInfo = false;
        OAuthProblemException ex = null;
        String lackAuthReason = "OAuth parameters were not found";
        for (TokenType tokenType : this.tokenTypes) {
            ResourceServer resourceServer = OAuthAccessResourceRequest.instantiateResourceServer(tokenType);
            for (ParameterStyle style : this.parameterStyles) {
                try {
                    OAuthValidator validator = resourceServer.instantiateValidator(style);
                    validator.validateContentType(this.request);
                    validator.validateMethod(this.request);
                    validator.validateRequiredParameters(this.request);
                    this.usedParameterStyle = style;
                    this.usedResourceServer = resourceServer;
                    ++foundValidStyles;
                }
                catch (OAuthProblemException e) {
                    if (OAuthUtils.isEmpty((String)e.getError())) {
                        lackAuthInfo = true;
                        lackAuthReason = e.getDescription();
                        continue;
                    }
                    ex = OAuthProblemException.error((String)e.getError(), (String)e.getDescription());
                }
            }
        }
        if (foundValidStyles > 1) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Found more than one mechanism for authenticating client");
        }
        if (ex != null) {
            throw ex;
        }
        if (foundValidStyles == 0 && lackAuthInfo) {
            throw OAuthProblemException.error(null, (String)lackAuthReason);
        }
        if (foundValidStyles == 0) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"OAuth parameters were not found");
        }
        this.extractor = this.usedResourceServer.instantiateExtractor(this.usedParameterStyle);
    }

    public static ResourceServer instantiateResourceServer(TokenType tokenType) throws OAuthSystemException {
        Class clazz = tokens.get(tokenType);
        if (clazz == null) {
            throw new OAuthSystemException("Cannot instantiate a resource server.");
        }
        return (ResourceServer)OAuthUtils.instantiateClass((Class)clazz);
    }
}

