/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextShape;

public final class DataExtraction {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Input file is required");
            return;
        }
        FileInputStream is = new FileInputStream(args[0]);
        XMLSlideShow ppt = new XMLSlideShow((InputStream)is);
        is.close();
        List embeds = ppt.getAllEmbedds();
        for (PackagePart p : embeds) {
            String type = p.getContentType();
            String name = p.getPartName().getName();
            InputStream pIs = p.getInputStream();
            pIs.close();
        }
        List images = ppt.getPictureData();
        for (XSLFPictureData data : images) {
            PackagePart p = data.getPackagePart();
            String type = p.getContentType();
            String name = data.getFileName();
            InputStream pIs = p.getInputStream();
            pIs.close();
        }
        Dimension pageSize = ppt.getPageSize();
        for (XSLFSlide slide : ppt.getSlides()) {
            for (XSLFShape shape : slide) {
                if (shape instanceof XSLFTextShape) {
                    XSLFTextShape txShape = (XSLFTextShape)shape;
                    System.out.println(txShape.getText());
                    continue;
                }
                if (shape instanceof XSLFPictureShape) {
                    XSLFPictureShape pShape = (XSLFPictureShape)shape;
                    XSLFPictureData pData = pShape.getPictureData();
                    System.out.println(pData.getFileName());
                    continue;
                }
                System.out.println("Process me: " + shape.getClass());
            }
        }
        ppt.close();
    }
}

