/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.converter;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;

public class AbstractExcelUtils {
    static final String EMPTY = "";
    private static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    private static final int UNIT_OFFSET_LENGTH = 7;

    public static String getAlign(short alignment) {
        switch (alignment) {
            case 2: {
                return "center";
            }
            case 6: {
                return "center";
            }
            case 4: {
                return EMPTY;
            }
            case 0: {
                return EMPTY;
            }
            case 5: {
                return "justify";
            }
            case 1: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return EMPTY;
    }

    public static String getBorderStyle(BorderStyle xlsBorder) {
        String borderStyle;
        switch (xlsBorder) {
            case NONE: {
                borderStyle = "none";
                break;
            }
            case DASH_DOT: 
            case DASH_DOT_DOT: 
            case DOTTED: 
            case HAIR: 
            case MEDIUM_DASH_DOT: 
            case MEDIUM_DASH_DOT_DOT: 
            case SLANTED_DASH_DOT: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: 
            case MEDIUM_DASHED: {
                borderStyle = "dashed";
                break;
            }
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        return borderStyle;
    }

    public static String getBorderWidth(BorderStyle xlsBorder) {
        String borderWidth;
        switch (xlsBorder) {
            case MEDIUM_DASH_DOT: 
            case MEDIUM_DASH_DOT_DOT: 
            case MEDIUM_DASHED: {
                borderWidth = "2pt";
                break;
            }
            case THICK: {
                borderWidth = "thick";
                break;
            }
            default: {
                borderWidth = "thin";
            }
        }
        return borderWidth;
    }

    public static String getColor(HSSFColor color) {
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append('#');
        for (short s : color.getTriplet()) {
            if (s < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(s));
        }
        String result = stringBuilder.toString();
        if (result.equals("#ffffff")) {
            return "white";
        }
        if (result.equals("#c0c0c0")) {
            return "silver";
        }
        if (result.equals("#808080")) {
            return "gray";
        }
        if (result.equals("#000000")) {
            return "black";
        }
        return result;
    }

    public static int getColumnWidthInPx(int widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
    }

    public static CellRangeAddress getMergedRange(CellRangeAddress[][] mergedRanges, int rowNumber, int columnNumber) {
        CellRangeAddress[] mergedRangeRowInfo = rowNumber < mergedRanges.length ? mergedRanges[rowNumber] : null;
        CellRangeAddress cellRangeAddress = mergedRangeRowInfo != null && columnNumber < mergedRangeRowInfo.length ? mergedRangeRowInfo[columnNumber] : null;
        return cellRangeAddress;
    }

    static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static boolean isNotEmpty(String str) {
        return !AbstractExcelUtils.isEmpty(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSFWorkbook loadXls(File xlsFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(xlsFile);
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)inputStream);
            return hSSFWorkbook;
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }
}

