/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.CodecException;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.crypto.hash.AbstractHash;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.Md2Hash;
import org.apache.shiro.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHash
extends AbstractHash {
    private final String algorithmName;
    private byte[] bytes = null;
    private transient String hexEncoded = null;
    private transient String base64Encoded = null;

    public SimpleHash(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public SimpleHash(String algorithmName, Object source) throws CodecException {
        this(algorithmName, source, null, 1);
    }

    public SimpleHash(String algorithmName, Object source, Object salt) throws CodecException {
        this(algorithmName, source, salt, 1);
    }

    public SimpleHash(String algorithmName, Object source, Object salt, int hashIterations) throws CodecException {
        if (!StringUtils.hasText(algorithmName)) {
            throw new NullPointerException("algorithmName argument cannot be null or empty.");
        }
        this.algorithmName = algorithmName;
        this.hash(source, salt, hashIterations);
    }

    private void hash(Object source, Object salt, int hashIterations) throws CodecException {
        byte[] sourceBytes = this.toBytes(source);
        byte[] saltBytes = null;
        if (salt != null) {
            saltBytes = this.toBytes(salt);
        }
        byte[] hashedBytes = this.hash(sourceBytes, saltBytes, hashIterations);
        this.setBytes(hashedBytes);
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(byte[] alreadyHashedBytes) {
        this.bytes = alreadyHashedBytes;
        this.hexEncoded = null;
        this.base64Encoded = null;
    }

    @Override
    protected MessageDigest getDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "No native '" + algorithmName + "' MessageDigest instance available on the current JVM.";
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    protected byte[] hash(byte[] bytes) {
        return this.hash(bytes, null, 1);
    }

    @Override
    protected byte[] hash(byte[] bytes, byte[] salt) {
        return this.hash(bytes, salt, 1);
    }

    @Override
    protected byte[] hash(byte[] bytes, byte[] salt, int hashIterations) {
        MessageDigest digest = this.getDigest(this.getAlgorithmName());
        if (salt != null) {
            digest.reset();
            digest.update(salt);
        }
        byte[] hashed = digest.digest(bytes);
        int iterations = hashIterations - 1;
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return hashed;
    }

    @Override
    public String toHex() {
        if (this.hexEncoded == null) {
            this.hexEncoded = Hex.encodeToString(this.getBytes());
        }
        return this.hexEncoded;
    }

    @Override
    public String toBase64() {
        if (this.base64Encoded == null) {
            this.base64Encoded = Base64.encodeToString(this.getBytes());
        }
        return this.base64Encoded;
    }

    @Override
    public String toString() {
        return this.toHex();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Hash) {
            Hash other = (Hash)o;
            return Arrays.equals(this.getBytes(), other.getBytes());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toHex().hashCode();
    }

    private static void printMainUsage(Class<? extends AbstractHash> clazz, String type) {
        System.out.println("Prints an " + type + " hash value.");
        System.out.println("Usage: java " + clazz.getName() + " [-base64] [-salt <saltValue>] [-times <N>] <valueToHash>");
        System.out.println("Options:");
        System.out.println("\t-base64\t\tPrints the hash value as a base64 String instead of the default hex.");
        System.out.println("\t-salt\t\tSalts the hash with the specified <saltValue>");
        System.out.println("\t-times\t\tHashes the input <N> number of times");
    }

    private static boolean isReserved(String arg) {
        return "-base64".equals(arg) || "-times".equals(arg) || "-salt".equals(arg);
    }

    static int doMain(Class<? extends AbstractHash> clazz, String[] args) {
        String simple = clazz.getSimpleName();
        int index = simple.indexOf("Hash");
        String type = simple.substring(0, index).toUpperCase();
        if (args == null || args.length < 1 || args.length > 7) {
            SimpleHash.printMainUsage(clazz, type);
            return -1;
        }
        boolean hex = true;
        String salt = null;
        int times = 1;
        String text = args[args.length - 1];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-base64")) {
                hex = false;
                continue;
            }
            if (arg.equals("-salt")) {
                if (i + 1 >= args.length - 1) {
                    String msg = "Salt argument must be followed by a salt value.  The final argument is reserved for the value to hash.";
                    System.out.println(msg);
                    SimpleHash.printMainUsage(clazz, type);
                    return -1;
                }
                salt = args[i + 1];
                continue;
            }
            if (!arg.equals("-times")) continue;
            if (i + 1 >= args.length - 1) {
                String msg = "Times argument must be followed by an integer value.  The final argument is reserved for the value to hash";
                System.out.println(msg);
                SimpleHash.printMainUsage(clazz, type);
                return -1;
            }
            try {
                times = Integer.valueOf(args[i + 1]);
                continue;
            }
            catch (NumberFormatException e) {
                String msg = "Times argument must be followed by an integer value.";
                System.out.println(msg);
                SimpleHash.printMainUsage(clazz, type);
                return -1;
            }
        }
        Md2Hash hash = new Md2Hash((Object)text, salt, times);
        String hashed = hex ? hash.toHex() : hash.toBase64();
        System.out.print(hex ? "Hex: " : "Base64: ");
        System.out.println(hashed);
        return 0;
    }
}

