/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.text.TextConfigurationRealm;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniRealm
extends TextConfigurationRealm {
    public static final String USERS_SECTION_NAME = "users";
    public static final String ROLES_SECTION_NAME = "roles";
    private static final transient Logger log = LoggerFactory.getLogger(IniRealm.class);
    private String resourcePath;

    public IniRealm() {
    }

    public IniRealm(Ini ini) {
        this();
        this.processDefinitions(ini);
    }

    public IniRealm(String resourcePath) {
        this();
        Ini ini = Ini.fromResourcePath(resourcePath);
        this.resourcePath = resourcePath;
        this.processDefinitions(ini);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onInit() {
        String resourcePath = this.getResourcePath();
        if (CollectionUtils.isEmpty(this.users) && CollectionUtils.isEmpty(this.roles)) {
            if (!StringUtils.hasText(resourcePath)) throw new IllegalStateException("No resource path was specified.  Cannot load account data.");
            log.debug("Resource path {} defined.  Creating INI instance.", (Object)resourcePath);
            Ini ini = Ini.fromResourcePath(resourcePath);
            this.processDefinitions(ini);
            return;
        } else {
            if (!StringUtils.hasText(resourcePath)) return;
            log.warn("Users or Roles are already populated.  Resource path property will be ignored.");
        }
    }

    private void processDefinitions(Ini ini) {
        Ini.Section usersSection;
        if (CollectionUtils.isEmpty(ini)) {
            log.warn("{} defined, but the ini instance is null or empty.", (Object)this.getClass().getSimpleName());
            return;
        }
        Ini.Section rolesSection = ini.getSection(ROLES_SECTION_NAME);
        if (!CollectionUtils.isEmpty(rolesSection)) {
            log.debug("Discovered the [{}] section.  Processing...", (Object)ROLES_SECTION_NAME);
            this.processRoleDefinitions(rolesSection);
        }
        if (!CollectionUtils.isEmpty(usersSection = ini.getSection(USERS_SECTION_NAME))) {
            log.debug("Discovered the [{}] section.  Processing...", (Object)USERS_SECTION_NAME);
            this.processUserDefinitions(usersSection);
        } else {
            log.info("{} defined, but there is no [{}] section defined.  This realm will not be populated with any users and it is assumed that they will be populated programatically.  Users must be defined for this Realm instance to be useful.", (Object)this.getClass().getSimpleName(), (Object)USERS_SECTION_NAME);
        }
    }
}

